/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.parameters.DHKeyDerivationParameters;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_X9_42_DH2_DERIVE_PARAMS;

public class X942DH2KeyDerivationParameters
extends DHKeyDerivationParameters {
    protected byte[] otherInfo;
    protected long privateDataLength;
    protected PKCS11Object privateData;
    protected byte[] publicData2;

    public X942DH2KeyDerivationParameters(long keyDerivationFunction, byte[] sharedData, byte[] publicData, long privateDataLength, PKCS11Object privateData, byte[] publicData2) {
        super(keyDerivationFunction, publicData);
        this.otherInfo = sharedData;
        this.privateDataLength = privateDataLength;
        this.privateData = Util.requireNonNull("privateData", privateData);
        this.publicData2 = Util.requireNonNull("publicData2", publicData2);
    }

    @Override
    public CK_X9_42_DH2_DERIVE_PARAMS getPKCS11ParamsObject() {
        CK_X9_42_DH2_DERIVE_PARAMS params = new CK_X9_42_DH2_DERIVE_PARAMS();
        params.kdf = this.kdf;
        params.pOtherInfo = this.otherInfo;
        params.pPublicData = this.publicData;
        params.ulPrivateDataLen = this.privateDataLength;
        params.hPrivateData = this.privateData.getObjectHandle();
        params.pPublicData2 = this.publicData2;
        return params;
    }

    public byte[] getOtherInfo() {
        return this.otherInfo;
    }

    public void setOtherInfo(byte[] otherInfo) {
        this.otherInfo = otherInfo;
    }

    public PKCS11Object getPrivateData() {
        return this.privateData;
    }

    public long getPrivateDataLength() {
        return this.privateDataLength;
    }

    public byte[] getPublicData2() {
        return this.publicData2;
    }

    public void setPrivateData(PKCS11Object privateData) {
        this.privateData = Util.requireNonNull("privateData", privateData);
    }

    public void setPrivateDataLength(long privateDataLength) {
        this.privateDataLength = privateDataLength;
    }

    public void setPublicData2(byte[] publicData2) {
        this.publicData2 = Util.requireNonNull("publicData2", publicData2);
    }

    @Override
    public String toString() {
        return Util.concatObjects(super.toString(), "\n  Other Info: ", Util.toHex(this.otherInfo), "\n  Private Data Length (dec): ", this.privateDataLength, "\n  Private Data: ", this.privateData, "\n  Public Data 2: ", Util.toHex(this.publicData2));
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof X942DH2KeyDerivationParameters)) {
            return false;
        }
        X942DH2KeyDerivationParameters other = (X942DH2KeyDerivationParameters)otherObject;
        return super.equals(other) && Arrays.equals(this.otherInfo, other.otherInfo) && this.privateDataLength == other.privateDataLength && this.privateData.equals(other.privateData) && Arrays.equals(this.publicData2, other.publicData2);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Util.hashCode(this.otherInfo) ^ (int)this.privateDataLength ^ this.privateData.hashCode() ^ Util.hashCode(this.publicData2);
    }
}

