/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.security.pkcs11.exception.P11UnknownEntityException;
import org.xipki.util.CompareUtil;
import org.xipki.util.ParamUtil;

public abstract class AbstractP11Module
implements P11Module {
    protected final P11ModuleConf conf;
    private final Map<P11SlotIdentifier, P11Slot> slots = new HashMap<P11SlotIdentifier, P11Slot>();
    private final List<P11SlotIdentifier> slotIds = new ArrayList<P11SlotIdentifier>();

    public AbstractP11Module(P11ModuleConf conf) {
        this.conf = (P11ModuleConf)ParamUtil.requireNonNull((String)"conf", (Object)conf);
    }

    @Override
    public String getName() {
        return this.conf.getName();
    }

    @Override
    public boolean isReadOnly() {
        return this.conf.isReadOnly();
    }

    @Override
    public P11ModuleConf getConf() {
        return this.conf;
    }

    protected void setSlots(Set<P11Slot> slots) {
        this.slots.clear();
        this.slotIds.clear();
        for (P11Slot slot : slots) {
            this.slots.put(slot.getSlotId(), slot);
            this.slotIds.add(slot.getSlotId());
        }
        Collections.sort(this.slotIds);
    }

    @Override
    public P11Slot getSlot(P11SlotIdentifier slotId) throws P11TokenException {
        ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        P11Slot slot = this.slots.get(slotId);
        if (slot == null) {
            throw new P11UnknownEntityException(slotId);
        }
        return slot;
    }

    void destroySlot(long slotId) {
        P11SlotIdentifier p11SlotId = null;
        for (P11SlotIdentifier si : this.slots.keySet()) {
            if (!CompareUtil.equalsObject((Object)si.getId(), (Object)slotId)) continue;
            p11SlotId = si;
            break;
        }
        if (p11SlotId != null) {
            this.slots.remove(p11SlotId);
        }
    }

    @Override
    public List<P11SlotIdentifier> getSlotIds() {
        return this.slotIds;
    }

    @Override
    public P11SlotIdentifier getSlotIdForIndex(int index) throws P11UnknownEntityException {
        for (P11SlotIdentifier id : this.slotIds) {
            if (id.getIndex() != index) continue;
            return id;
        }
        throw new P11UnknownEntityException("could not find slot with index " + index);
    }

    @Override
    public P11SlotIdentifier getSlotIdForId(long id) throws P11UnknownEntityException {
        for (P11SlotIdentifier slotId : this.slotIds) {
            if (slotId.getId() != id) continue;
            return slotId;
        }
        throw new P11UnknownEntityException("could not find slot with id " + id);
    }
}

