/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11MacContentSigner;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;

public class P11MacContentSignerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(P11MacContentSignerBuilder.class);
    private final P11CryptService cryptService;
    private final P11IdentityId identityId;

    public P11MacContentSignerBuilder(P11CryptService cryptService, P11IdentityId identityId) {
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.identityId = (P11IdentityId)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
    }

    public ConcurrentContentSigner createSigner(AlgorithmIdentifier signatureAlgId, int parallelism) throws XiSecurityException, P11TokenException {
        DfltConcurrentContentSigner concurrentSigner;
        ParamUtil.requireMin((String)"parallelism", (int)parallelism, (int)1);
        ArrayList<P11MacContentSigner> signers = new ArrayList<P11MacContentSigner>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            P11MacContentSigner signer = new P11MacContentSigner(this.cryptService, this.identityId, signatureAlgId);
            signers.add(signer);
        }
        boolean mac = true;
        try {
            concurrentSigner = new DfltConcurrentContentSigner(true, signers, null);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
        }
        try {
            byte[] sha1HashOfKey = this.cryptService.getIdentity(this.identityId).digestSecretKey(544L);
            concurrentSigner.setSha1DigestOfMacKey(sha1HashOfKey);
        }
        catch (XiSecurityException | P11TokenException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not compute the digest of secret key " + this.identityId));
        }
        return concurrentSigner;
    }
}

