/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import iaik.pkcs.pkcs11.constants.Functions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.security.pkcs11.P11MechanismFilter;
import org.xipki.security.pkcs11.P11NewObjectConf;
import org.xipki.security.pkcs11.P11PasswordsRetriever;
import org.xipki.security.pkcs11.P11SlotIdFilter;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.jaxb.MechanismFilterType;
import org.xipki.security.pkcs11.jaxb.MechanismFiltersType;
import org.xipki.security.pkcs11.jaxb.MechanismSetType;
import org.xipki.security.pkcs11.jaxb.MechnanismSetsType;
import org.xipki.security.pkcs11.jaxb.ModuleType;
import org.xipki.security.pkcs11.jaxb.NativeLibraryType;
import org.xipki.security.pkcs11.jaxb.PasswordSetsType;
import org.xipki.security.pkcs11.jaxb.PasswordsType;
import org.xipki.security.pkcs11.jaxb.SlotType;
import org.xipki.security.pkcs11.jaxb.SlotsType;
import org.xipki.util.CollectionUtil;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class P11ModuleConf {
    private static final Logger LOG = LoggerFactory.getLogger(P11ModuleConf.class);
    private final String name;
    private final String type;
    private final String nativeLibrary;
    private final boolean readOnly;
    private final Set<P11SlotIdFilter> excludeSlots;
    private final Set<P11SlotIdFilter> includeSlots;
    private final P11PasswordsRetriever passwordRetriever;
    private final P11MechanismFilter mechanismFilter;
    private final int maxMessageSize;
    private final long userType;
    private final P11NewObjectConf newObjectConf;

    public P11ModuleConf(ModuleType moduleType, MechnanismSetsType mechanismSetsType, PasswordResolver passwordResolver) throws InvalidConfException {
        ParamUtil.requireNonNull((String)"moduleType", (Object)moduleType);
        ParamUtil.requireNonNull((String)"mechanismSetsType", (Object)mechanismSetsType);
        this.name = moduleType.getName();
        this.readOnly = moduleType.isReadonly();
        String userTypeStr = moduleType.getUser().toUpperCase();
        if ("CKU_USER".equals(userTypeStr)) {
            this.userType = 1L;
        } else if ("CKU_SO".equals(userTypeStr)) {
            this.userType = 0L;
        } else if ("CKU_CONTEXT_SPECIFIC".equals(userTypeStr)) {
            this.userType = 2L;
        } else {
            try {
                this.userType = userTypeStr.startsWith("0X") ? Long.parseLong(userTypeStr.substring(2), 16) : Long.parseLong(userTypeStr);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfException("invalid user " + userTypeStr);
            }
        }
        this.maxMessageSize = moduleType.getMaxMessageSize();
        this.type = moduleType.getType();
        if (this.maxMessageSize < 128) {
            throw new InvalidConfException("invalid maxMessageSize (< 128): " + this.maxMessageSize);
        }
        List<MechanismSetType> list = mechanismSetsType.getMechanismSet();
        HashMap mechanismSetsMap = new HashMap(list.size() * 3 / 2);
        for (MechanismSetType mechanismSetType : list) {
            String string = mechanismSetType.getName();
            if (mechanismSetsMap.containsKey(string)) {
                throw new InvalidConfException("Duplication mechanismSets named " + string);
            }
            HashSet<Long> mechanisms = new HashSet<Long>();
            for (String mechStr : mechanismSetType.getMechanism()) {
                if ((mechStr = mechStr.trim().toUpperCase()).equals("ALL")) {
                    mechanisms = null;
                    break;
                }
                Long mech = null;
                if (mechStr.startsWith("CKM_")) {
                    mech = Functions.mechanismStringToCode((String)mechStr);
                } else {
                    int radix = 10;
                    if (mechStr.startsWith("0X")) {
                        radix = 16;
                        mechStr = mechStr.substring(2);
                    }
                    if (mechStr.endsWith("UL")) {
                        mechStr = mechStr.substring(0, mechStr.length() - 2);
                    } else if (mechStr.endsWith("L")) {
                        mechStr = mechStr.substring(0, mechStr.length() - 1);
                    }
                    try {
                        mech = Long.parseLong(mechStr, radix);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (mech == null) {
                    LOG.warn("skipped unknown mechanism '" + mechStr + "'");
                    continue;
                }
                mechanisms.add(mech);
            }
            mechanismSetsMap.put(string, mechanisms);
        }
        this.mechanismFilter = new P11MechanismFilter();
        MechanismFiltersType mechFilters = moduleType.getMechanismFilters();
        if (mechFilters != null && CollectionUtil.isNonEmpty(mechFilters.getMechanismFilter())) {
            for (MechanismFilterType mechanismFilterType : mechFilters.getMechanismFilter()) {
                Set<P11SlotIdFilter> slots = P11ModuleConf.getSlotIdFilters(mechanismFilterType.getSlots());
                String mechanismSetName = mechanismFilterType.getMechanismSet();
                if (!mechanismSetsMap.containsKey(mechanismSetName)) {
                    throw new InvalidConfException("MechanismSet '" + mechanismSetName + "' is not defined");
                }
                Set mechanisms = (Set)mechanismSetsMap.get(mechanismSetName);
                if (mechanisms == null) {
                    this.mechanismFilter.addAcceptAllEntry(slots);
                    continue;
                }
                this.mechanismFilter.addEntry(slots, mechanisms);
            }
        }
        this.passwordRetriever = new P11PasswordsRetriever();
        PasswordSetsType passwordSetsType = moduleType.getPasswordSets();
        if (passwordSetsType != null && CollectionUtil.isNonEmpty(passwordSetsType.getPasswords())) {
            this.passwordRetriever.setPasswordResolver(passwordResolver);
            for (PasswordsType passwordType : passwordSetsType.getPasswords()) {
                Set<P11SlotIdFilter> slots = P11ModuleConf.getSlotIdFilters(passwordType.getSlots());
                this.passwordRetriever.addPasswordEntry(slots, new ArrayList<String>(passwordType.getPassword()));
            }
        }
        this.includeSlots = P11ModuleConf.getSlotIdFilters(moduleType.getIncludeSlots());
        this.excludeSlots = P11ModuleConf.getSlotIdFilters(moduleType.getExcludeSlots());
        String string = System.getProperty("os.name").toLowerCase();
        String nativeLibraryPath = null;
        for (NativeLibraryType library : moduleType.getNativeLibraries().getNativeLibrary()) {
            List<String> osNames = library.getOs();
            if (CollectionUtil.isEmpty(osNames)) {
                nativeLibraryPath = library.getPath();
            } else {
                for (String entry : osNames) {
                    if (!string.contains(entry.toLowerCase())) continue;
                    nativeLibraryPath = library.getPath();
                    break;
                }
            }
            if (nativeLibraryPath == null) continue;
            break;
        }
        if (nativeLibraryPath == null) {
            throw new InvalidConfException("could not find PKCS#11 library for OS " + string);
        }
        this.nativeLibrary = nativeLibraryPath;
        this.newObjectConf = moduleType.getNewObjectConf() == null ? new P11NewObjectConf() : new P11NewObjectConf(moduleType.getNewObjectConf());
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getNativeLibrary() {
        return this.nativeLibrary;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long getUserType() {
        return this.userType;
    }

    public P11PasswordsRetriever getPasswordRetriever() {
        return this.passwordRetriever;
    }

    public boolean isSlotIncluded(P11SlotIdentifier slotId) {
        boolean included;
        ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        if (CollectionUtil.isEmpty(this.includeSlots)) {
            included = true;
        } else {
            included = false;
            for (P11SlotIdFilter entry : this.includeSlots) {
                if (!entry.match(slotId)) continue;
                included = true;
                break;
            }
        }
        if (!included) {
            return false;
        }
        if (CollectionUtil.isEmpty(this.excludeSlots)) {
            return included;
        }
        for (P11SlotIdFilter entry : this.excludeSlots) {
            if (!entry.match(slotId)) continue;
            return false;
        }
        return true;
    }

    public P11MechanismFilter getP11MechanismFilter() {
        return this.mechanismFilter;
    }

    public P11NewObjectConf getP11NewObjectConf() {
        return this.newObjectConf;
    }

    private static Set<P11SlotIdFilter> getSlotIdFilters(SlotsType type) throws InvalidConfException {
        if (type == null || CollectionUtil.isEmpty(type.getSlot())) {
            return null;
        }
        HashSet<P11SlotIdFilter> filters = new HashSet<P11SlotIdFilter>();
        for (SlotType slotType : type.getSlot()) {
            Long slotId = null;
            if (slotType.getId() != null) {
                String str = slotType.getId().trim();
                try {
                    slotId = StringUtil.startsWithIgnoreCase((String)str, (String)"0X") ? Long.parseLong(str.substring(2), 16) : Long.parseLong(str);
                }
                catch (NumberFormatException ex) {
                    String message = "invalid slotId '" + str + "'";
                    LOG.error(message);
                    throw new InvalidConfException(message);
                }
            }
            filters.add(new P11SlotIdFilter(slotType.getIndex(), slotId));
        }
        return filters;
    }
}

