/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ModuleFactory;
import org.xipki.security.pkcs11.P11ModuleFactoryRegister;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.util.LogUtil;

public class P11ModuleFactoryRegisterImpl
implements P11ModuleFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(P11ModuleFactoryRegisterImpl.class);
    private static final Map<String, P11Module> modules = new HashMap<String, P11Module>();
    private ConcurrentLinkedDeque<P11ModuleFactory> services = new ConcurrentLinkedDeque();

    public void bindService(P11ModuleFactory service) {
        if (service == null) {
            LOG.info("bindService invoked with null.");
            return;
        }
        boolean replaced = this.services.remove(service);
        this.services.add(service);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} P11ModuleFactory binding for {}", (Object)action, (Object)service);
    }

    public void unbindService(P11ModuleFactory service) {
        if (service == null) {
            LOG.info("unbindService invoked with null.");
            return;
        }
        if (this.services.remove(service)) {
            LOG.info("removed P11ModuleFactory binding for {}", (Object)service);
        } else {
            LOG.info("no P11ModuleFactory binding found to remove for '{}'", (Object)service);
        }
    }

    @Override
    public P11Module getP11Module(P11ModuleConf conf) throws P11TokenException {
        String type = conf.getType().toLowerCase();
        String nativeLib = conf.getNativeLibrary();
        String key = type + ":" + nativeLib;
        P11Module p11Module = modules.get(key);
        if (p11Module == null) {
            for (P11ModuleFactory service : this.services) {
                if (!service.canCreateModule(type)) continue;
                p11Module = service.newModule(conf);
                break;
            }
            if (p11Module == null) {
                throw new P11TokenException("could not find Factory to create PKCS#11 module of type '" + type + "'");
            }
            modules.put(key, p11Module);
        }
        return p11Module;
    }

    public void shutdown() {
        for (String pk11Lib : modules.keySet()) {
            try {
                modules.get(pk11Lib).close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not close PKCS11 Module " + pk11Lib));
            }
        }
        modules.clear();
        this.services.clear();
    }
}

