/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xipki.security.pkcs11.jaxb.NewObjectConfType;
import org.xipki.util.ParamUtil;

public class P11NewObjectConf {
    private boolean ignoreLabel;
    private int idLength = 8;
    private Set<Long> setCertObjectAttributes;

    public P11NewObjectConf(NewObjectConfType jaxb) {
        Boolean bb = jaxb.isIgnoreLabel();
        this.ignoreLabel = bb == null ? false : bb;
        Integer ii = jaxb.getIdLength();
        this.idLength = ii == null ? 8 : ii;
        NewObjectConfType.CertAttributes attrs = jaxb.getCertAttributes();
        HashSet<Long> set = new HashSet<Long>();
        if (attrs != null) {
            for (String attr : attrs.getAttribute()) {
                if ("CKA_START_DATE".equals(attr = attr.toUpperCase())) {
                    set.add(272L);
                    continue;
                }
                if ("CKA_END_DATE".equals(attr)) {
                    set.add(273L);
                    continue;
                }
                if ("CKA_SUBJECT".equals(attr)) {
                    set.add(257L);
                    continue;
                }
                if ("CKA_ISSUER".equals(attr)) {
                    set.add(129L);
                    continue;
                }
                if (!"CKA_SERIAL_NUMBER".equals(attr)) continue;
                set.add(130L);
            }
        }
        this.setCertObjectAttributes = Collections.unmodifiableSet(set);
    }

    public P11NewObjectConf() {
        this.setCertObjectAttributes = Collections.emptySet();
    }

    public boolean isIgnoreLabel() {
        return this.ignoreLabel;
    }

    public void setIgnoreLabel(boolean ignoreLabel) {
        this.ignoreLabel = ignoreLabel;
    }

    public int getIdLength() {
        return this.idLength;
    }

    public void setIdLength(int idLength) {
        this.idLength = idLength;
    }

    public Set<Long> getSetCertObjectAttributes() {
        return this.setCertObjectAttributes;
    }

    public void setSetCertObjectAttributes(Set<Long> setCertObjectAttributes) {
        this.setCertObjectAttributes = (Set)ParamUtil.requireNonNull((String)"setCertObjectAttributes", setCertObjectAttributes);
    }
}

