/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import iaik.pkcs.pkcs11.constants.PKCS11Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiContentSigner;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11ByteArrayParams;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.security.util.GMUtil;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;

class P11SM2ContentSigner
implements XiContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(P11SM2ContentSigner.class);
    private static final Map<String, HashAlgo> sigAlgHashMap = new HashMap<String, HashAlgo>();
    private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
    private final P11CryptService cryptService;
    private final P11IdentityId identityId;
    private final AlgorithmIdentifier algorithmIdentifier;
    private final byte[] encodedAlgorithmIdentifier;
    private final long mechanism;
    private final OutputStream outputStream;
    private final byte[] z;

    P11SM2ContentSigner(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId, ASN1ObjectIdentifier curveOid, BigInteger pubPointX, BigInteger pubPointY) throws XiSecurityException, P11TokenException {
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.identityId = (P11IdentityId)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        this.algorithmIdentifier = (AlgorithmIdentifier)ParamUtil.requireNonNull((String)"signatureAlgId", (Object)signatureAlgId);
        try {
            this.encodedAlgorithmIdentifier = this.algorithmIdentifier.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", (Throwable)ex);
        }
        String algOid = signatureAlgId.getAlgorithm().getId();
        HashAlgo hashAlgo = sigAlgHashMap.get(algOid);
        if (hashAlgo == null) {
            throw new XiSecurityException("unsupported signature algorithm " + algOid);
        }
        P11Slot slot = cryptService.getSlot(identityId.getSlotId());
        if (slot.supportsMechanism(PKCS11Constants.CKM_VENDOR_SM2)) {
            this.z = GMUtil.getSM2Z((ASN1ObjectIdentifier)curveOid, (BigInteger)pubPointX, (BigInteger)pubPointY);
            this.mechanism = PKCS11Constants.CKM_VENDOR_SM2;
            Digest digest = hashAlgo.createDigest();
            this.outputStream = new DigestOutputStream(digest);
        } else {
            this.z = null;
            Long ll = hashMechMap.get(hashAlgo);
            if (ll == null) {
                throw new XiSecurityException("hash algorithm " + hashAlgo + " is not suitable for SM2");
            }
            this.mechanism = ll;
            if (!slot.supportsMechanism(this.mechanism)) {
                throw new XiSecurityException("unsupported signature algorithm " + algOid);
            }
            this.outputStream = new ByteArrayOutputStream();
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    public OutputStream getOutputStream() {
        this.reset();
        return this.outputStream;
    }

    private void reset() {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            ((DigestOutputStream)this.outputStream).reset();
            try {
                this.outputStream.write(this.z, 0, this.z.length);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.getMessage());
            }
        }
    }

    public byte[] getSignature() {
        try {
            byte[] plainSignature = this.getPlainSignature();
            return SignerUtil.dsaSigPlainToX962((byte[])plainSignature);
        }
        catch (XiSecurityException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex);
            throw new RuntimeCryptoException("XiSecurityException: " + ex.getMessage());
        }
        catch (Throwable th) {
            LogUtil.warn((Logger)LOG, (Throwable)th);
            throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
        }
    }

    private byte[] getPlainSignature() throws XiSecurityException, P11TokenException {
        byte[] dataToSign;
        P11ByteArrayParams params;
        if (this.outputStream instanceof ByteArrayOutputStream) {
            params = new P11ByteArrayParams(GMUtil.getDefaultIDA());
            dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
        } else {
            params = null;
            dataToSign = ((DigestOutputStream)this.outputStream).digest();
        }
        this.reset();
        return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, params, dataToSign);
    }

    static {
        sigAlgHashMap.put(GMObjectIdentifiers.sm2sign_with_sm3.getId(), HashAlgo.SM3);
        hashMechMap.put(HashAlgo.SM3, PKCS11Constants.CKM_VENDOR_SM2_SM3);
    }
}

