/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.SignerFactory;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11ContentSignerBuilder;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11MacContentSignerBuilder;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.util.Hex;
import org.xipki.util.ObjectCreationException;

public class PKCS11SignerFactory
implements SignerFactory {
    private static final String TYPE = "pkcs11";
    private static final Set<String> types = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("pkcs11")));
    private P11CryptServiceFactory p11CryptServiceFactory;
    private SecurityFactory securityFactory;

    public void setP11CryptServiceFactory(P11CryptServiceFactory p11CryptServiceFactory) {
        this.p11CryptServiceFactory = p11CryptServiceFactory;
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public Set<String> getSupportedSignerTypes() {
        return types;
    }

    public boolean canCreateSigner(String type) {
        return types.contains(type.toLowerCase());
    }

    public ConcurrentContentSigner newSigner(String type, SignerConf conf, X509Certificate[] certificateChain) throws ObjectCreationException {
        P11Slot slot;
        P11CryptService p11Service;
        Long slotId;
        if (!TYPE.equalsIgnoreCase(type)) {
            throw new ObjectCreationException("unknown signer type " + type);
        }
        if (this.p11CryptServiceFactory == null) {
            throw new ObjectCreationException("p11CryptServiceFactory is not set");
        }
        if (this.securityFactory == null) {
            throw new ObjectCreationException("securityFactory is not set");
        }
        String str = conf.getConfValue("parallelism");
        int parallelism = this.securityFactory.getDfltSignerParallelism();
        if (str != null) {
            try {
                parallelism = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
            if (parallelism < 1) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
        }
        String moduleName = conf.getConfValue("module");
        str = conf.getConfValue("slot");
        Integer slotIndex = str == null ? null : Integer.valueOf(Integer.parseInt(str));
        str = conf.getConfValue("slot-id");
        Long l = slotId = str == null ? null : Long.valueOf(Long.parseLong(str));
        if (slotIndex == null && slotId == null || slotIndex != null && slotId != null) {
            throw new ObjectCreationException("exactly one of slot (index) and slot-id must be specified");
        }
        String keyLabel = conf.getConfValue("key-label");
        str = conf.getConfValue("key-id");
        byte[] keyId = null;
        if (str != null) {
            keyId = Hex.decode((String)str);
        }
        if (keyId == null && keyLabel == null || keyId != null && keyLabel != null) {
            throw new ObjectCreationException("exactly one of key-id and key-label must be specified");
        }
        try {
            P11SlotIdentifier p11SlotId;
            p11Service = this.p11CryptServiceFactory.getP11CryptService(moduleName);
            P11Module module = p11Service.getModule();
            if (slotId != null) {
                p11SlotId = module.getSlotIdForId(slotId);
            } else if (slotIndex != null) {
                p11SlotId = module.getSlotIdForIndex(slotIndex);
            } else {
                throw new RuntimeException("should not reach here");
            }
            slot = module.getSlot(p11SlotId);
        }
        catch (XiSecurityException | P11TokenException ex) {
            throw new ObjectCreationException(ex.getMessage(), ex);
        }
        P11IdentityId identityId = slot.getIdentityId(keyId, keyLabel);
        if (identityId == null) {
            String str2 = keyId != null ? "id " + Hex.encode((byte[])keyId) : "label " + keyLabel;
            throw new ObjectCreationException("cound not find identity with " + str2);
        }
        try {
            AlgorithmIdentifier signatureAlgId;
            AlgorithmIdentifier macAlgId = null;
            String algoName = conf.getConfValue("algo");
            if (algoName != null) {
                try {
                    macAlgId = AlgorithmUtil.getMacAlgId((String)algoName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (macAlgId != null) {
                P11MacContentSignerBuilder signerBuilder = new P11MacContentSignerBuilder(p11Service, identityId);
                return signerBuilder.createSigner(macAlgId, parallelism);
            }
            if (conf.getHashAlgo() == null) {
                signatureAlgId = AlgorithmUtil.getSigAlgId(null, (SignerConf)conf);
            } else {
                PublicKey pubKey = slot.getIdentity(identityId.getKeyId()).getPublicKey();
                signatureAlgId = AlgorithmUtil.getSigAlgId((PublicKey)pubKey, (SignerConf)conf);
            }
            P11ContentSignerBuilder signerBuilder = new P11ContentSignerBuilder(p11Service, this.securityFactory, identityId, certificateChain);
            return signerBuilder.createSigner(signatureAlgId, parallelism);
        }
        catch (NoSuchAlgorithmException | XiSecurityException | P11TokenException ex) {
            throw new ObjectCreationException(ex.getMessage(), ex);
        }
    }
}

