/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.password.PBEPasswordService;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.SinglePasswordResolver;
import org.xipki.password.callback.FilePasswordCallback;
import org.xipki.password.callback.GuiPasswordCallback;
import org.xipki.password.callback.OBFPasswordCallback;
import org.xipki.password.callback.PBEConsumerPasswordCallback;
import org.xipki.password.callback.PBEGuiPasswordCallback;
import org.xipki.password.callback.PasswordCallback;

public class PBESinglePasswordResolver
implements SinglePasswordResolver {
    private char[] masterPassword;
    private final Object masterPasswordLock = new Object();
    private String masterPasswordCallback = "PBE-GUI";
    private PasswordCallback masterPwdCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] getMasterPassword(String encryptedPassword) throws PasswordResolverException {
        Object object = this.masterPasswordLock;
        synchronized (object) {
            this.init();
            if (this.masterPassword == null) {
                if (this.masterPwdCallback == null) {
                    throw new PasswordResolverException("masterPasswordCallback is not initialized");
                }
                this.masterPassword = this.masterPwdCallback.getPassword("Please enter the master password", encryptedPassword);
            }
            return this.masterPassword;
        }
    }

    private void init() {
        PasswordCallback pwdCallback;
        String type;
        if (this.masterPwdCallback != null) {
            return;
        }
        if (StringUtil.isBlank((String)this.masterPasswordCallback)) {
            return;
        }
        String conf = null;
        int delimIndex = this.masterPasswordCallback.indexOf(32);
        if (delimIndex == -1) {
            type = this.masterPasswordCallback;
        } else {
            type = this.masterPasswordCallback.substring(0, delimIndex);
            conf = this.masterPasswordCallback.substring(delimIndex + 1);
        }
        if ("FILE".equalsIgnoreCase(type)) {
            pwdCallback = new FilePasswordCallback();
        } else if ("GUI".equalsIgnoreCase(type)) {
            pwdCallback = new GuiPasswordCallback();
        } else if ("PBE-GUI".equalsIgnoreCase(type)) {
            pwdCallback = new PBEGuiPasswordCallback();
        } else if ("PBE-Consumer".equalsIgnoreCase(type)) {
            pwdCallback = new PBEConsumerPasswordCallback();
        } else if ("OBF".equalsIgnoreCase(type)) {
            pwdCallback = new OBFPasswordCallback();
            if (conf != null && !conf.startsWith("OBF:")) {
                conf = "OBF:" + conf;
            }
        } else {
            throw new RuntimeException("unknown PasswordCallback type '" + type + "'");
        }
        try {
            pwdCallback.init(conf);
        }
        catch (PasswordResolverException ex) {
            throw new IllegalArgumentException("invalid masterPasswordCallback configuration " + this.masterPasswordCallback + ", " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        this.masterPwdCallback = pwdCallback;
    }

    public void clearMasterPassword() {
        this.masterPassword = null;
    }

    @Override
    public boolean canResolveProtocol(String protocol) {
        return "PBE".equalsIgnoreCase(protocol);
    }

    @Override
    public char[] resolvePassword(String passwordHint) throws PasswordResolverException {
        return PBEPasswordService.decryptPassword(this.getMasterPassword(passwordHint), passwordHint);
    }

    public void setMasterPasswordCallback(String masterPasswordCallback) {
        this.masterPasswordCallback = ParamUtil.requireNonBlank((String)"masterPasswordCallback", (String)masterPasswordCallback).trim();
    }
}

