/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolverException;

public class PasswordProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordProducer.class);
    private static ConcurrentHashMap<String, BlockingQueue<char[]>> namePasswordsMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> nameResultMap = new ConcurrentHashMap();

    public static void registerPasswordConsumer(String name) {
        PasswordProducer.assertNameNotBlank(name);
        LinkedBlockingQueue queue = new LinkedBlockingQueue(1);
        nameResultMap.remove(name);
        namePasswordsMap.put(name, queue);
        String str = "registered password consumer " + name;
        System.out.println(str);
        LOG.info(str);
    }

    public static void unregisterPasswordConsumer(String name) {
        PasswordProducer.assertNameNotBlank(name);
        namePasswordsMap.remove(name);
        String str = "unregistered password consumer " + name;
        System.out.println(str);
        LOG.info(str);
    }

    public static void setPasswordCorrect(String name, boolean correct) {
        PasswordProducer.assertNameNotBlank(name);
        nameResultMap.put(name, correct);
        String str = "set result of password consumer " + name + ": " + (correct ? "valid" : "invalid");
        System.out.println(str);
        LOG.info(str);
    }

    public static Boolean removePasswordCorrect(String name) {
        return nameResultMap.remove(name);
    }

    public static char[] takePassword(String name) throws InterruptedException, PasswordResolverException {
        PasswordProducer.assertNameNotBlank(name);
        if (!namePasswordsMap.containsKey(name)) {
            throw new PasswordResolverException("password consumer '" + name + "' is not registered ");
        }
        char[] pwd = namePasswordsMap.get(name).take();
        String str = "took password consumer " + name;
        System.out.println(str);
        return pwd;
    }

    public static void putPassword(String name, char[] password) throws InterruptedException, PasswordResolverException {
        PasswordProducer.assertNameNotBlank(name);
        if (!namePasswordsMap.containsKey(name)) {
            throw new PasswordResolverException("password consumer '" + name + "' is not registered ");
        }
        nameResultMap.remove(name);
        namePasswordsMap.get(name).put(password);
        String str = "provided password consumer " + name;
        System.out.println(str);
    }

    public static boolean needsPassword(String name) {
        PasswordProducer.assertNameNotBlank(name);
        if (!namePasswordsMap.containsKey(name)) {
            return false;
        }
        return namePasswordsMap.get(name).isEmpty();
    }

    public static Set<String> getNames() {
        return Collections.unmodifiableSet(namePasswordsMap.keySet());
    }

    private static void assertNameNotBlank(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name must not be empty");
        }
    }
}

