/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password.callback;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.ConfPairs;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.password.OBFPasswordService;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.callback.PasswordCallback;

public class FilePasswordCallback
implements PasswordCallback {
    private static final Logger LOG = LoggerFactory.getLogger(FilePasswordCallback.class);
    private String passwordFile;

    @Override
    public char[] getPassword(String prompt, String testToken) throws PasswordResolverException {
        if (this.passwordFile == null) {
            throw new PasswordResolverException("please initialize me first");
        }
        String passwordHint = null;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(FilePasswordCallback.expandFilepath(this.passwordFile)));
            while ((line = reader.readLine()) != null) {
                if (!StringUtil.isNotBlank((String)(line = line.trim())) || line.startsWith("#")) continue;
                passwordHint = line;
                break;
            }
        }
        catch (IOException ex) {
            throw new PasswordResolverException("could not read file " + this.passwordFile, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOG.error("could not close reader: {}", (Object)ex.getMessage());
                }
            }
        }
        if (passwordHint == null) {
            throw new PasswordResolverException("no password is specified in file " + this.passwordFile);
        }
        if (StringUtil.startsWithIgnoreCase(passwordHint, (String)"OBF:")) {
            return OBFPasswordService.deobfuscate(passwordHint).toCharArray();
        }
        return passwordHint.toCharArray();
    }

    @Override
    public void init(String conf) throws PasswordResolverException {
        ParamUtil.requireNonBlank((String)"conf", (String)conf);
        ConfPairs pairs = new ConfPairs(conf);
        this.passwordFile = pairs.value("file");
        if (StringUtil.isBlank((String)this.passwordFile)) {
            throw new PasswordResolverException("invalid configuration " + conf + ", no file is specified");
        }
        this.passwordFile = FilePasswordCallback.expandFilepath(this.passwordFile);
    }

    private static String expandFilepath(String path) {
        return path.startsWith("~" + File.separator) ? System.getProperty("user.home") + path.substring(1) : path;
    }
}

