/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmatchers.xpath;

import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.w3c.dom.Node;
import org.xmlmatchers.transform.IdentityTransformer;
import org.xmlmatchers.xpath.XpathReturnType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasXPath
extends TypeSafeMatcher<Source> {
    private static final IdentityTransformer IDENTITY = new IdentityTransformer();
    private final String xPathString;
    private final XPathExpression compiledXPath;
    private final XpathReturnType<?> xPathReturnType;
    private final Matcher<?> valueMatcher;

    protected HasXPath(String xPathExpression) {
        this(xPathExpression, null, null);
    }

    protected HasXPath(String xPathExpression, Matcher<? super String> valueMatcher, NamespaceContext namespaceContext) {
        this(xPathExpression, valueMatcher, namespaceContext, XpathReturnType.returningAString());
    }

    public HasXPath(String xPathExpression, Matcher<?> valueMatcher, NamespaceContext namespaceContext, XpathReturnType<?> xPathReturnType) {
        try {
            XPath xPath = this.buildXPath();
            if (namespaceContext != null) {
                xPath.setNamespaceContext(namespaceContext);
            }
            this.compiledXPath = xPath.compile(xPathExpression);
            this.xPathString = xPathExpression;
            this.valueMatcher = valueMatcher;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Invalid XPath : " + xPathExpression, e);
        }
        this.xPathReturnType = xPathReturnType == null ? XpathReturnType.returningAString() : xPathReturnType;
    }

    private XPath buildXPath() {
        System.setProperty("javax.xml.xpath.XPathFactory:http://saxon.sf.net/jaxp/xpath/om", "net.sf.saxon.xpath.XPathFactoryImpl");
        try {
            return XPathFactory.newInstance("http://saxon.sf.net/jaxp/xpath/om").newXPath();
        }
        catch (XPathFactoryConfigurationException e) {
            throw new UnsupportedOperationException("Saxon is incorrectly configured or not available on the classpath", e);
        }
    }

    public void describeTo(Description description) {
        description.appendText("an XML document with XPath " + this.xPathString);
        if (this.valueMatcher != null) {
            description.appendText(" matching ");
            this.valueMatcher.describeTo(description);
        }
    }

    public boolean matchesSafely(Source source) {
        try {
            Node node = this.convert(source);
            if (this.valueMatcher == null) {
                return this.evaluateXPathForExistence(node);
            }
            Object xPathResult = this.evaluateXPath(node);
            return this.valueMatcher.matches(xPathResult);
        }
        catch (XPathExpressionException e) {
            return false;
        }
        catch (TransformerException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Node convert(Source source) {
        DOMResult dom = new DOMResult();
        IDENTITY.transform(source, dom);
        return dom.getNode();
    }

    private boolean evaluateXPathForExistence(Node node) throws TransformerException, XPathExpressionException {
        return this.compiledXPath.evaluate(node, XPathConstants.NODE) != null;
    }

    private Object evaluateXPath(Node node) throws TransformerException, XPathExpressionException {
        if (XPathConstants.NODE == this.xPathReturnType.evaluationMode()) {
            Node result = (Node)this.compiledXPath.evaluate(node, XPathConstants.NODE);
            return new DOMSource(result);
        }
        return this.compiledXPath.evaluate(node, this.xPathReturnType.evaluationMode());
    }

    @Factory
    public static Matcher<Source> hasXPath(String xPath) {
        return new HasXPath(xPath);
    }

    @Factory
    public static Matcher<Source> hasXPath(String xPath, NamespaceContext namespaceContext) {
        return new HasXPath(xPath, null, namespaceContext);
    }

    @Factory
    public static Matcher<Source> hasXPath(String xPath, Matcher<? super String> valueMatcher) {
        return new HasXPath(xPath, valueMatcher, null);
    }

    @Factory
    public static Matcher<Source> hasXPath(String xPath, NamespaceContext namespaceContext, Matcher<? super String> valueMatcher) {
        return new HasXPath(xPath, valueMatcher, namespaceContext);
    }

    @Factory
    public static <T> Matcher<Source> hasXPath(String xPath, XpathReturnType<? super T> xpathReturnType, Matcher<? super T> valueMatcher) {
        return new HasXPath(xPath, valueMatcher, null, xpathReturnType);
    }

    @Factory
    public static <T> Matcher<Source> hasXPath(String xPath, NamespaceContext namespaceContext, XpathReturnType<? super T> xpathReturnType, Matcher<? super T> valueMatcher) {
        return new HasXPath(xPath, valueMatcher, namespaceContext, xpathReturnType);
    }

    @Factory
    public static Matcher<Source> hasXPath(String xPath, Matcher<? super String> valueMatcher, NamespaceContext namespaceContext) {
        return new HasXPath(xPath, valueMatcher, namespaceContext);
    }
}

