/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj.error;

import org.xmlunit.assertj.error.ComparisonFailureErrorFactory;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonFormatter;

public class ShouldBeSimilar
extends ComparisonFailureErrorFactory {
    private final String reason;
    private final String controlString;
    private final String testString;

    private ShouldBeSimilar(String reason, String controlString, String testString) {
        this.reason = reason;
        this.controlString = controlString;
        this.testString = testString;
    }

    @Override
    String getMessage() {
        return this.reason;
    }

    @Override
    String getExpected() {
        return this.controlString;
    }

    @Override
    String getActual() {
        return this.testString;
    }

    public static ShouldBeSimilar shouldBeIdentical(String controlSystemId, String testSystemId, Comparison comparison, ComparisonFormatter formatter, boolean formatXml) {
        return new ShouldBeSimilar(ShouldBeSimilar.createReasonPrefix(controlSystemId, testSystemId, "identical", comparison, formatter), formatter.getDetails(comparison.getControlDetails(), comparison.getType(), formatXml), formatter.getDetails(comparison.getTestDetails(), comparison.getType(), formatXml));
    }

    public static ShouldBeSimilar shouldBeSimilar(String controlSystemId, String testSystemId, Comparison comparison, ComparisonFormatter formatter, boolean formatXml) {
        return new ShouldBeSimilar(ShouldBeSimilar.createReasonPrefix(controlSystemId, testSystemId, "similar", comparison, formatter), formatter.getDetails(comparison.getControlDetails(), comparison.getType(), formatXml), formatter.getDetails(comparison.getTestDetails(), comparison.getType(), formatXml));
    }

    private static String createReasonPrefix(String controlSystemId, String testSystemId, String type, Comparison difference, ComparisonFormatter formatter) {
        controlSystemId = controlSystemId != null ? controlSystemId : "control instance";
        testSystemId = testSystemId != null ? testSystemId : "test instance";
        String description = formatter.getDescription(difference);
        return String.format("%nExpecting:%n <%s> and <%s> to be %s%n%s", controlSystemId, testSystemId, type, description);
    }
}

