/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.netty;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class Sequence {
    private final List<Runnable> tasks;
    private int next;

    public Sequence(int length) {
        this.tasks = new LinkedList<Object>(Collections.nCopies(length, null));
    }

    synchronized void set(int index, Runnable task) {
        this.tasks.set(index, task);
        if (index == this.next) {
            this.runEagerly();
        }
    }

    private void runEagerly() {
        int end = this.tasks.size();
        for (Runnable task : this.tasks.subList(this.next, end)) {
            if (task == null) {
                return;
            }
            task.run();
            this.tasks.set(this.next, null);
            ++this.next;
        }
        this.next = 0;
    }

    boolean hasSecondTask() {
        return this.tasks.get(1) != null;
    }
}

