/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.core;

import com.fasterxml.jackson.core.JsonPointer;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u0006H\u0002J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/zalando/zally/core/JsonPointerLocator;", "", "contents", "", "(Ljava/lang/String;)V", "yaml", "Lorg/yaml/snakeyaml/nodes/Node;", "isJson", "", "locate", "Lkotlin/ranges/IntRange;", "pointer", "Lcom/fasterxml/jackson/core/JsonPointer;", "node", "parent", "locateCollection", "Lorg/yaml/snakeyaml/nodes/CollectionNode;", "locateMapping", "Lorg/yaml/snakeyaml/nodes/MappingNode;", "zally-core"})
public final class JsonPointerLocator {
    private final Node yaml;

    private final boolean isJson(String contents) {
        String $this$trim$iv = contents;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return StringsKt.startsWith$default((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (String)"{", (boolean)false, (int)2, null);
    }

    @Nullable
    public final IntRange locate(@NotNull JsonPointer pointer) {
        IntRange intRange;
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Node node = this.yaml;
        if (node != null) {
            Node node2 = node;
            boolean bl = false;
            boolean bl2 = false;
            Node it = node2;
            boolean bl3 = false;
            intRange = JsonPointerLocator.locate$default(this, pointer, this.yaml, null, 4, null);
        } else {
            intRange = null;
        }
        return intRange;
    }

    private final IntRange locate(JsonPointer pointer, Node node, Node parent) {
        IntRange intRange;
        Node node2 = node;
        if ((node2 instanceof MappingNode ? this.locateMapping(pointer, (MappingNode)node) : (intRange = node2 instanceof CollectionNode ? this.locateCollection(pointer, (CollectionNode)node) : null)) == null) {
            Mark mark = parent.getStartMark();
            Intrinsics.checkNotNullExpressionValue((Object)mark, (String)"parent.startMark");
            int n = mark.getLine() + 1;
            Mark mark2 = node.getEndMark();
            Intrinsics.checkNotNullExpressionValue((Object)mark2, (String)"node.endMark");
            intRange = new IntRange(n, mark2.getLine() + 1);
        }
        return intRange;
    }

    static /* synthetic */ IntRange locate$default(JsonPointerLocator jsonPointerLocator, JsonPointer jsonPointer, Node node, Node node2, int n, Object object) {
        if ((n & 4) != 0) {
            node2 = node;
        }
        return jsonPointerLocator.locate(jsonPointer, node, node2);
    }

    /*
     * WARNING - void declaration
     */
    private final IntRange locateMapping(JsonPointer pointer, MappingNode node) {
        void $this$mapNotNullTo$iv$iv;
        List list = node.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.value");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IntRange intRange;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            NodeTuple tuple = (NodeTuple)element$iv$iv;
            boolean bl2 = false;
            NodeTuple nodeTuple = tuple;
            Intrinsics.checkNotNullExpressionValue((Object)nodeTuple, (String)"tuple");
            Node keyNode = nodeTuple.getKeyNode();
            if (keyNode instanceof ScalarNode && pointer.matchesProperty(((ScalarNode)keyNode).getValue())) {
                JsonPointer jsonPointer = pointer.tail();
                Intrinsics.checkNotNullExpressionValue((Object)jsonPointer, (String)"pointer.tail()");
                Node node2 = tuple.getValueNode();
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"tuple.valueNode");
                intRange = this.locate(jsonPointer, node2, keyNode);
            } else {
                intRange = null;
            }
            if (intRange == null) continue;
            IntRange intRange2 = intRange;
            boolean bl3 = false;
            boolean bl4 = false;
            IntRange it$iv$iv = intRange2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (IntRange)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final IntRange locateCollection(JsonPointer pointer, CollectionNode<?> node) {
        void $this$mapIndexedNotNullTo$iv$iv;
        List list = node.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.value");
        Iterable $this$mapIndexedNotNull$iv = list;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            IntRange intRange;
            void any;
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl2 = false;
            void var18_18 = element$iv$iv;
            int index = index$iv$iv;
            boolean bl3 = false;
            if (any instanceof Node && pointer.matchesElement(index)) {
                JsonPointer jsonPointer = pointer.tail();
                Intrinsics.checkNotNullExpressionValue((Object)jsonPointer, (String)"pointer.tail()");
                intRange = JsonPointerLocator.locate$default(this, jsonPointer, (Node)any, null, 4, null);
            } else {
                intRange = null;
            }
            if (intRange == null) continue;
            IntRange intRange2 = intRange;
            boolean bl4 = false;
            boolean bl5 = false;
            IntRange it$iv$iv = intRange2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (IntRange)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    public JsonPointerLocator(@NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        this.yaml = this.isJson(contents) ? null : new Yaml().compose((Reader)new StringReader(contents));
    }
}

