/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.core;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.util.Json;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.core.ContentParseResult;
import org.zalando.zally.core.ObjectTreeReader;
import org.zalando.zally.core.RulesManager;
import org.zalando.zally.core.RulesValidator;
import org.zalando.zally.core.ast.ReverseAst;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/zalando/zally/core/JsonRulesValidator;", "Lorg/zalando/zally/core/RulesValidator;", "Lcom/fasterxml/jackson/databind/JsonNode;", "rules", "Lorg/zalando/zally/core/RulesManager;", "(Lorg/zalando/zally/core/RulesManager;)V", "ast", "Lorg/zalando/zally/core/ast/ReverseAst;", "createAst", "json", "ignore", "", "root", "pointer", "Lcom/fasterxml/jackson/core/JsonPointer;", "ruleId", "", "parse", "Lorg/zalando/zally/core/ContentParseResult;", "content", "authorization", "zally-core"})
public final class JsonRulesValidator
extends RulesValidator<JsonNode> {
    private ReverseAst ast;

    @Override
    @NotNull
    public ContentParseResult<JsonNode> parse(@NotNull String content, @Nullable String authorization) {
        ContentParseResult contentParseResult;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            JsonNode json = ObjectTreeReader.read$default(new ObjectTreeReader(), content, null, 2, null);
            this.ast = this.createAst(json);
            contentParseResult = new ContentParseResult.ParsedSuccessfully<JsonNode>(json);
        }
        catch (Exception e) {
            contentParseResult = new ContentParseResult.NotApplicable();
        }
        return contentParseResult;
    }

    private final ReverseAst createAst(JsonNode json) {
        ReverseAst reverseAst;
        Map map;
        try {
            map = (Map)Json.mapper().convertValue((Object)json, Map.class);
        }
        catch (Exception e) {
            map = null;
        }
        Map map2 = map;
        if (map2 != null) {
            map = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map it = map;
            boolean bl3 = false;
            reverseAst = ReverseAst.Companion.fromObject(it).build();
        } else {
            reverseAst = null;
        }
        return reverseAst;
    }

    @Override
    public boolean ignore(@NotNull JsonNode root, @NotNull JsonPointer pointer, @NotNull String ruleId) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        ReverseAst reverseAst = this.ast;
        return reverseAst != null ? reverseAst.isIgnored(pointer, ruleId) : false;
    }

    public JsonRulesValidator(@NotNull RulesManager rules) {
        Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
        super(rules);
    }
}

