/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.core;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfigurationBuilder;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.github.fge.msgsimple.source.MessageSource;
import com.github.fge.msgsimple.source.PropertiesMessageSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.core.JsonSchemaValidator;
import org.zalando.zally.rule.api.Violation;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u001c\u0010\u0016\u001a\u00020\t2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\u001e\u001a\u00020\u0003R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/zalando/zally/core/JsonSchemaValidator;", "", "schema", "Lcom/fasterxml/jackson/databind/JsonNode;", "schemaRedirects", "", "", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/util/Map;)V", "factory", "Lcom/github/fge/jsonschema/main/JsonSchemaFactory;", "getSchema", "()Lcom/fasterxml/jackson/databind/JsonNode;", "createLoadingConfiguration", "Lcom/github/fge/jsonschema/core/load/configuration/LoadingConfiguration;", "createValidationMessageWithSchemaPath", "Lorg/zalando/zally/rule/api/Violation;", "node", "message", "pointer", "Lcom/fasterxml/jackson/core/JsonPointer;", "createValidationMessageWithSchemaRefs", "keyword", "createValidatorFactory", "getValidationMessagesBundle", "Lcom/github/fge/msgsimple/bundle/MessageBundle;", "toValidationMessage", "processingMessage", "Lcom/github/fge/jsonschema/core/report/ProcessingMessage;", "validate", "", "jsonToValidate", "Keywords", "zally-core"})
public final class JsonSchemaValidator {
    private final JsonSchemaFactory factory;
    @NotNull
    private final JsonNode schema;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Violation> validate(@NotNull JsonNode jsonToValidate) throws ProcessingException, IOException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)jsonToValidate, (String)"jsonToValidate");
        ProcessingReport processingReport = this.factory.getValidator().validateUnchecked(this.schema, jsonToValidate, true);
        Intrinsics.checkNotNullExpressionValue((Object)processingReport, (String)"factory\n        .validat\u2026ma, jsonToValidate, true)");
        Iterable iterable = (Iterable)processingReport;
        JsonSchemaValidator jsonSchemaValidator = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            ProcessingMessage processingMessage = (ProcessingMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Violation violation = jsonSchemaValidator.toValidationMessage((ProcessingMessage)p1);
            collection.add(violation);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Violation toValidationMessage(ProcessingMessage processingMessage) {
        Violation violation;
        JsonNode node = processingMessage.asJson();
        String keyword = node.path("keyword").textValue();
        String string = node.path("message").textValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.path(\"message\").textValue()");
        String message = StringsKt.capitalize((String)string);
        Object object = node.at("/instance/pointer");
        if (object == null || (object = object.textValue()) == null || (object = JsonPointerExtensionsKt.toJsonPointer((String)object)) == null) {
            object = JsonPointer.empty();
        }
        Object object2 = object;
        String string2 = keyword;
        if (string2 != null) {
            switch (string2) {
                case "oneOf": 
                case "anyOf": {
                    JsonNode jsonNode = node;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"node");
                    Object object3 = object2;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"pointer");
                    violation = this.createValidationMessageWithSchemaRefs(jsonNode, message, (JsonPointer)object3, keyword);
                    return violation;
                }
                case "additionalProperties": {
                    JsonNode jsonNode = node;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"node");
                    Object object4 = object2;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"pointer");
                    violation = this.createValidationMessageWithSchemaPath(jsonNode, message, (JsonPointer)object4);
                    return violation;
                }
            }
        }
        Object object5 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"pointer");
        violation = new Violation(message, (JsonPointer)object5);
        return violation;
    }

    /*
     * WARNING - void declaration
     */
    private final Violation createValidationMessageWithSchemaRefs(JsonNode node, String message, JsonPointer pointer, String keyword) {
        Violation violation;
        String schemaPath = node.at("/schema/pointer").textValue();
        CharSequence charSequence = schemaPath;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            JsonNode schemaRefNodes;
            JsonNode jsonNode = schemaRefNodes = this.schema.at(schemaPath + '/' + keyword);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"schemaRefNodes");
            Iterable iterable = (Iterable)jsonNode;
            boolean $i$f$map = false;
            void var10_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                JsonNode jsonNode3 = it.path("$ref");
                collection.add(jsonNode3);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                JsonNode p1 = (JsonNode)element$iv$iv;
                boolean bl4 = false;
                if (p1.isMissingNode()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String schemaRefs2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"; ", null, null, (int)0, null, (Function1)createValidationMessageWithSchemaRefs.schemaRefs.3.INSTANCE, (int)30, null);
            violation = new Violation(message + schemaRefs2, pointer);
        } else {
            violation = new Violation(message, pointer);
        }
        return violation;
    }

    private final Violation createValidationMessageWithSchemaPath(JsonNode node, String message, JsonPointer pointer) {
        String schemaPath = node.at("/schema/pointer").textValue();
        return new Violation(message + schemaPath, pointer);
    }

    private final JsonSchemaFactory createValidatorFactory(Map<String, String> schemaRedirects) {
        MessageBundle validationMessages = this.getValidationMessagesBundle();
        ValidationConfiguration validationConfiguration = ValidationConfiguration.newBuilder().setValidationMessages(validationMessages).freeze();
        LoadingConfiguration loadingConfig = this.createLoadingConfiguration(schemaRedirects);
        JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.newBuilder().setValidationConfiguration(validationConfiguration).setLoadingConfiguration(loadingConfig).freeze();
        Intrinsics.checkNotNullExpressionValue((Object)jsonSchemaFactory, (String)"JsonSchemaFactory.newBui\u2026ig)\n            .freeze()");
        return jsonSchemaFactory;
    }

    /*
     * WARNING - void declaration
     */
    private final LoadingConfiguration createLoadingConfiguration(Map<String, String> schemaRedirects) {
        URITranslatorConfigurationBuilder urlTranslatorConfig = URITranslatorConfiguration.newBuilder();
        Map<String, String> $this$forEach$iv = schemaRedirects;
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void from;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$from$to = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$from$to;
            boolean bl3 = false;
            String string = entry.getKey();
            entry = $dstr$from$to;
            bl3 = false;
            String to = entry.getValue();
            urlTranslatorConfig.addSchemaRedirect((String)from, to);
        }
        return LoadingConfiguration.newBuilder().setURITranslatorConfiguration(urlTranslatorConfig.freeze()).freeze();
    }

    private final MessageBundle getValidationMessagesBundle() {
        MessageSource customValidationMessages = PropertiesMessageSource.fromResource((String)"/schema-validation-messages.properties");
        MessageBundle messageBundle = MessageBundles.getBundle(JsonSchemaValidationBundle.class).thaw().appendSource(customValidationMessages).freeze();
        Intrinsics.checkNotNullExpressionValue((Object)messageBundle, (String)"MessageBundles.getBundle\u2026es)\n            .freeze()");
        return messageBundle;
    }

    @NotNull
    public final JsonNode getSchema() {
        return this.schema;
    }

    public JsonSchemaValidator(@NotNull JsonNode schema, @NotNull Map<String, String> schemaRedirects) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(schemaRedirects, (String)"schemaRedirects");
        this.schema = schema;
        this.factory = this.createValidatorFactory(schemaRedirects);
    }

    public /* synthetic */ JsonSchemaValidator(JsonNode jsonNode, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        this(jsonNode, map);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/zalando/zally/core/JsonSchemaValidator$Keywords;", "", "()V", "additionalProperties", "", "anyOf", "oneOf", "zally-core"})
    private static final class Keywords {
        @NotNull
        public static final String oneOf = "oneOf";
        @NotNull
        public static final String anyOf = "anyOf";
        @NotNull
        public static final String additionalProperties = "additionalProperties";
        @NotNull
        public static final Keywords INSTANCE;

        private Keywords() {
        }

        static {
            Keywords keywords;
            INSTANCE = keywords = new Keywords();
        }
    }
}

