/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit5.jms;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.util.Optional;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zapodot.jms.common.EmbeddedJMSBrokerHolder;
import org.zapodot.junit5.jms.annotations.BrokerConfig;
import org.zapodot.junit5.jms.annotations.EmbeddedJms;
import org.zapodot.junit5.jms.internal.BrokerConfiguration;
import org.zapodot.junit5.jms.internal.BrokerConfigurationBuilder;
import org.zapodot.junit5.jms.internal.FieldInjector;

public class EmbeddedJmsBroker
implements BeforeEachCallback,
AfterEachCallback,
TestInstancePostProcessor,
ParameterResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedJmsBroker.class);
    private static final ExtensionContext.Namespace EMBEDDED_JMS_EXT = ExtensionContext.Namespace.create((Object[])new Object[]{"org.zapodot.junit5.jms"});
    private static final String TEST_INSTANCE = "TestInstance";
    private static final String STORE_EMBEDDED_JMS_BROKER = "EmbeddedJmsBroker";
    private static final String STORE_BROKER_CONFIGURATION = "BrokerConfiguration";

    private static EmbeddedJMSBrokerHolder getOrCreateEmbeddedJMSBrokerHolder(ExtensionContext context) {
        EmbeddedJMSBrokerHolder embeddedJmsBrokerHolder = (EmbeddedJMSBrokerHolder)context.getStore(EMBEDDED_JMS_EXT).get((Object)STORE_EMBEDDED_JMS_BROKER, EmbeddedJMSBrokerHolder.class);
        if (embeddedJmsBrokerHolder == null) {
            embeddedJmsBrokerHolder = EmbeddedJmsBroker.createEmbeddedJmsBrokerHolderOrDefault(context, (BrokerConfiguration)context.getStore(EMBEDDED_JMS_EXT).get((Object)STORE_BROKER_CONFIGURATION, BrokerConfiguration.class));
            context.getStore(EMBEDDED_JMS_EXT).put((Object)STORE_EMBEDDED_JMS_BROKER, (Object)embeddedJmsBrokerHolder);
        }
        return embeddedJmsBrokerHolder;
    }

    private static EmbeddedJMSBrokerHolder createEmbeddedJmsBrokerHolderOrDefault(ExtensionContext extensionContext, BrokerConfiguration brokerConfiguration) {
        return EmbeddedJmsBroker.createEmbeddedJmsBrokerHolder(extensionContext, brokerConfiguration).orElseGet(() -> EmbeddedJMSBrokerHolder.create((String)EmbeddedJmsBroker.extractNameFromExtensionContext(extensionContext), (boolean)false, (boolean)false));
    }

    private static Optional<BrokerConfiguration> createBrokerConfigurationFromContext(ExtensionContext extensionContext) {
        return EmbeddedJmsBroker.findAnnotation(extensionContext.getElement(), BrokerConfig.class).map(BrokerConfigurationBuilder::fromBrokerConfigAnnotation).map(BrokerConfigurationBuilder::build);
    }

    private static Optional<EmbeddedJMSBrokerHolder> createEmbeddedJmsBrokerHolder(ExtensionContext extensionContext, BrokerConfiguration brokerConfiguration) {
        LOGGER.debug("Constructing broker using configuration \"{}\"", (Object)brokerConfiguration);
        return Optional.ofNullable(brokerConfiguration).map(b -> EmbeddedJmsBroker.createEmbeddedJMSBrokerHolderFromBrokerConfig(b, EmbeddedJmsBroker.extractNameFromExtensionContext(extensionContext)));
    }

    private static String extractNameFromExtensionContext(ExtensionContext extensionContext) {
        return extensionContext.getTestClass().map(Class::getSimpleName).orElse(extensionContext.getUniqueId());
    }

    private static EmbeddedJMSBrokerHolder createEmbeddedJMSBrokerHolderFromBrokerConfig(BrokerConfiguration brokerConfig, String nameFromTest) {
        Boolean marshall = Optional.ofNullable(brokerConfig.getMarshal()).orElse(Boolean.FALSE);
        Boolean persistence = Optional.ofNullable(brokerConfig.getPersistenceEnabled()).orElse(Boolean.FALSE);
        String name = Optional.ofNullable(brokerConfig.getName()).filter(n -> !Strings.isNullOrEmpty((String)n)).orElse(nameFromTest);
        LOGGER.info("Creating an embedded JMS broker using name \"{}\"", (Object)name);
        return EmbeddedJMSBrokerHolder.create((String)name, (boolean)marshall, (boolean)persistence);
    }

    private static <A extends Annotation> Optional<A> findAnnotation(Optional<? extends AnnotatedElement> element, Class<A> annotationType) {
        if (!element.isPresent()) {
            return Optional.empty();
        }
        return element.flatMap(e -> EmbeddedJmsBroker.findAnnotationForElement(annotationType, e));
    }

    private static <A extends Annotation> Optional<A> findAnnotationForElement(Class<A> annotationType, AnnotatedElement e) {
        return AnnotationUtils.findAnnotation((AnnotatedElement)e, annotationType);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.isAnnotated(EmbeddedJms.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        Parameter parameter = parameterContext.getParameter();
        EmbeddedJMSBrokerHolder embeddedJMSBrokerHolder = (EmbeddedJMSBrokerHolder)context.getStore(EMBEDDED_JMS_EXT).get((Object)STORE_EMBEDDED_JMS_BROKER, EmbeddedJMSBrokerHolder.class);
        if (ActiveMQConnectionFactory.class.isAssignableFrom(parameter.getType())) {
            return embeddedJMSBrokerHolder.getActiveMQConnectionFactory();
        }
        if (ConnectionFactory.class.isAssignableFrom(parameter.getType())) {
            return embeddedJMSBrokerHolder.getConnectionFactory();
        }
        if (URI.class.isAssignableFrom(parameter.getType())) {
            return embeddedJMSBrokerHolder.getBrokerUri();
        }
        return null;
    }

    public void afterEach(ExtensionContext context) {
        LOGGER.debug("afterEach \"{}\"", (Object)context.getTestClass());
        Optional.ofNullable(context.getStore(EMBEDDED_JMS_EXT).get((Object)STORE_EMBEDDED_JMS_BROKER, EmbeddedJMSBrokerHolder.class)).ifPresent(embeddedJMSBrokerHolder -> {
            try {
                embeddedJMSBrokerHolder.close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not close down Embedded broker", e);
            }
        });
    }

    public void beforeEach(ExtensionContext context) {
        LOGGER.debug("beforeEach \"{}\"", (Object)context.getTestClass());
        BrokerConfiguration brokerConfigurationFromInstance = (BrokerConfiguration)context.getStore(EMBEDDED_JMS_EXT).get((Object)STORE_BROKER_CONFIGURATION, BrokerConfiguration.class);
        Optional.ofNullable(BrokerConfigurationBuilder.fromInstance(BrokerConfiguration.DEFAULT).mergeWithBrokerConfiguration(brokerConfigurationFromInstance)).map(brokerConfigurationBuilder -> {
            EmbeddedJmsBroker.createBrokerConfigurationFromContext(context).ifPresent(brokerConfigurationBuilder::mergeWithBrokerConfiguration);
            return brokerConfigurationBuilder;
        }).map(BrokerConfigurationBuilder::build).ifPresent(c -> context.getStore(EMBEDDED_JMS_EXT).put((Object)STORE_BROKER_CONFIGURATION, c));
        EmbeddedJMSBrokerHolder embeddedJmsBrokerHolder = EmbeddedJmsBroker.getOrCreateEmbeddedJMSBrokerHolder(context);
        embeddedJmsBrokerHolder.start();
        Object testInstance = context.getStore(EMBEDDED_JMS_EXT).get((Object)TEST_INSTANCE);
        if (testInstance == null) {
            testInstance = context.getTestInstance().orElse(null);
        }
        Optional.ofNullable(testInstance).ifPresent(ti -> FieldInjector.injectToInstance(ti, embeddedJmsBrokerHolder));
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        LOGGER.debug("postProcessTestInstance instance: \"{}\"", testInstance);
        context.getStore(EMBEDDED_JMS_EXT).put((Object)TEST_INSTANCE, testInstance);
        EmbeddedJmsBroker.createBrokerConfigurationFromContext(context).ifPresent(c -> context.getStore(EMBEDDED_JMS_EXT).put((Object)STORE_BROKER_CONFIGURATION, c));
    }
}

