/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SortEvent;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.ArrayComparator;
import org.zkoss.zul.Columns;
import org.zkoss.zul.FieldComparator;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.GroupComparator;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowComparator;
import org.zkoss.zul.Rows;
import org.zkoss.zul.ext.GroupsSortableModel;
import org.zkoss.zul.ext.Sortable;
import org.zkoss.zul.impl.HeaderElement;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.mesg.MZul;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column
extends HeaderElement {
    private String _sortDir = "natural";
    private transient Comparator<?> _sortAsc;
    private transient Comparator<?> _sortDsc;
    private String _sortAscNm = "none";
    private String _sortDscNm = "none";
    private Object _value;
    private boolean _ignoreSort = false;
    private boolean _isCustomAscComparator = false;
    private boolean _isCustomDscComparator = false;

    public Column() {
    }

    public Column(String label) {
        super(label);
    }

    public Column(String label, String src) {
        super(label, src);
    }

    public Column(String label, String src, String width) {
        super(label, src);
        this.setWidth(width);
    }

    public Grid getGrid() {
        Component parent = this.getParent();
        return parent != null ? (Grid)parent.getParent() : null;
    }

    public String getSortDirection() {
        return this._sortDir;
    }

    public void setSortDirection(String sortDir) throws WrongValueException {
        if (sortDir == null || !"ascending".equals(sortDir) && !"descending".equals(sortDir) && !"natural".equals(sortDir)) {
            throw new WrongValueException("Unknown sort direction: " + sortDir);
        }
        if (!Objects.equals((Object)this._sortDir, (Object)sortDir)) {
            Grid grid;
            this._sortDir = sortDir;
            if (!"natural".equals(sortDir) && !this._ignoreSort && (grid = this.getGrid()) != null && grid.isAutosort()) {
                this.doSort("ascending".equals(sortDir));
            }
            this.smartUpdate("sortDirection", this._sortDir);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSort(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (type == null) {
            return;
        }
        if (type.startsWith("client")) {
            this.setSortAscending(type);
            this.setSortDescending(type);
            return;
        } else if ("auto".equals(type)) {
            if (this.getSortAscending() == null) {
                this.setSortAscending(new RowComparator(this, true, false, false));
            }
            if (this.getSortDescending() != null) return;
            this.setSortDescending(new RowComparator(this, false, false, false));
            return;
        } else if (type.startsWith("auto")) {
            char cc;
            int j = type.indexOf(40);
            int k = type.lastIndexOf(41);
            if (j < 0 || k < 0) throw new UiException("Unknown sort type: " + type);
            String name = type.substring(j + 1, k);
            int index = -1;
            if (name.length() > 0 && (cc = name.charAt(0)) >= '0' && cc <= '9' && (index = Integer.parseInt(name)) < 0) {
                throw new IllegalArgumentException("Nonnegative number is required: " + name);
            }
            if (this.getSortAscending() == null || !this._isCustomAscComparator) {
                if (index < 0) {
                    this.setSortAscending(new FieldComparator(name, true));
                } else {
                    this.setSortAscending(new ArrayComparator(index, true));
                }
                this._isCustomAscComparator = false;
            }
            if (this.getSortDescending() != null && this._isCustomDscComparator) return;
            if (index < 0) {
                this.setSortDescending(new FieldComparator(name, false));
            } else {
                this.setSortDescending(new ArrayComparator(index, false));
            }
            this._isCustomDscComparator = false;
            return;
        } else {
            if (!"none".equals(type)) return;
            this.setSortAscending((Comparator)null);
            this.setSortDescending((Comparator)null);
        }
    }

    public Comparator<?> getSortAscending() {
        return this._sortAsc;
    }

    public void setSortAscending(Comparator<?> sorter) {
        if (!Objects.equals(this._sortAsc, sorter)) {
            String nm;
            this._sortAsc = sorter;
            this._isCustomAscComparator = this._sortAsc != null;
            String string = nm = this._isCustomAscComparator ? "fromServer" : "none";
            if (!this._sortAscNm.equals(nm)) {
                this._sortAscNm = nm;
                this.smartUpdate("sortAscending", this._sortAscNm);
            }
        }
    }

    public void setSortAscending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortAscNm.equals(clsnm)) {
            this._sortAscNm = clsnm;
            this.smartUpdate("sortAscending", clsnm);
        } else {
            this.setSortAscending(this.toComparator(clsnm));
        }
    }

    public Comparator<?> getSortDescending() {
        return this._sortDsc;
    }

    public void setSortDescending(Comparator<?> sorter) {
        if (!Objects.equals(this._sortDsc, sorter)) {
            String nm;
            this._sortDsc = sorter;
            this._isCustomDscComparator = this._sortDsc != null;
            String string = nm = this._isCustomDscComparator ? "fromServer" : "none";
            if (!this._sortDscNm.equals(nm)) {
                this._sortDscNm = nm;
                this.smartUpdate("sortDescending", this._sortDscNm);
            }
        }
    }

    public void setSortDescending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortDscNm.equals(clsnm)) {
            this._sortDscNm = clsnm;
            this.smartUpdate("sortDescending", clsnm);
        } else {
            this.setSortDescending(this.toComparator(clsnm));
        }
    }

    private Comparator<?> toComparator(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls;
        if (clsnm == null || clsnm.length() == 0) {
            return null;
        }
        Page page = this.getPage();
        Class clazz = cls = page != null ? page.resolveClass(clsnm) : Classes.forNameByThread((String)clsnm);
        if (cls == null) {
            throw new ClassNotFoundException(clsnm);
        }
        if (!Comparator.class.isAssignableFrom(cls)) {
            throw new UiException("Comparator must be implemented: " + clsnm);
        }
        return (Comparator)cls.newInstance();
    }

    public boolean sort(boolean ascending) {
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        return this.doSort(ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doSort(boolean ascending) {
        Comparator<?> cmpr;
        Comparator<?> comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Grid grid = this.getGrid();
        if (grid == null) {
            return false;
        }
        Rows rows = grid.getRows();
        if (rows == null) {
            return false;
        }
        Scopes.beforeInterpret((Scope)this);
        try {
            int activePg;
            ListModel model = grid.getModel();
            boolean isPagingMold = grid.inPagingMold();
            int n = activePg = isPagingMold ? grid.getPaginal().getActivePage() : 0;
            if (model != null) {
                if (model instanceof GroupsSortableModel) {
                    this.sortGroupsModel(grid, (GroupsSortableModel)((Object)model), cmpr, ascending);
                } else {
                    if (!(model instanceof Sortable)) {
                        throw new UiException("Sortable must be implemented in " + model.getClass());
                    }
                    this.sortListModel((Sortable)((Object)model), cmpr, ascending);
                }
            } else {
                Column.sort0(grid, cmpr);
            }
            if (isPagingMold) {
                grid.getPaginal().setActivePage(activePg);
            }
        }
        finally {
            Scopes.afterInterpret();
        }
        this.fixDirection(grid, ascending);
        grid.getRows().invalidate();
        return true;
    }

    private void sortGroupsModel(Grid grid, GroupsSortableModel model, Comparator cmpr, boolean ascending) {
        model.sort(cmpr, ascending, grid.getColumns().getChildren().indexOf((Object)this));
    }

    private void sortListModel(Sortable model, Comparator cmpr, boolean ascending) {
        model.sort(cmpr, ascending);
    }

    private static void sort0(Grid grid, Comparator cmpr) {
        Rows rows = grid.getRows();
        if (rows.hasGroup()) {
            for (Group g : rows.getGroups()) {
                int index = g.getIndex() + 1;
                Components.sort(rows.getChildren(), (int)index, (int)(index + g.getItemCount()), (Comparator)cmpr);
            }
        } else {
            Components.sort(rows.getChildren(), (Comparator)cmpr);
        }
    }

    private void fixDirection(Grid grid, boolean ascending) {
        this._ignoreSort = true;
        Iterator it = grid.getColumns().getChildren().iterator();
        while (it.hasNext()) {
            Column hd;
            hd.setSortDirection((hd = (Column)((Object)it.next())) != this ? "natural" : (ascending ? "ascending" : "descending"));
        }
        this._ignoreSort = false;
    }

    public boolean sort(boolean ascending, boolean force) {
        if (force) {
            this.setSortDirection("natural");
        }
        return this.sort(ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean group(boolean ascending) {
        GroupToComparator cmpr;
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Grid grid = this.getGrid();
        if (grid == null) {
            return false;
        }
        Scopes.beforeInterpret((Scope)this);
        try {
            ListModel model = grid.getModel();
            int index = grid.getColumns().getChildren().indexOf((Object)this);
            if (model != null) {
                if (!(model instanceof GroupsSortableModel)) {
                    throw new UiException(GroupsSortableModel.class + " must be implemented in " + model.getClass().getName());
                }
                this.groupGroupsModel((GroupsSortableModel)((Object)model), cmpr, ascending, index);
            } else {
                Rows rows = grid.getRows();
                if (rows == null) {
                    boolean bl = false;
                    return bl;
                }
                if (rows.hasGroup()) {
                    for (Group group : new ArrayList<Group>(rows.getGroups())) {
                        group.detach();
                    }
                }
                GroupToComparator cmprx = cmpr instanceof GroupComparator ? new GroupToComparator((GroupComparator)((Object)cmpr)) : cmpr;
                LinkedList<Component> children = new LinkedList<Component>(rows.getChildren());
                rows.getChildren().clear();
                Column.sortCollection(children, cmprx);
                Row previous = null;
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    Row row = (Row)((Object)it.next());
                    it.remove();
                    if (previous == null || Column.compare(cmprx, previous, (Object)row) != 0) {
                        Group group;
                        List cells = row.getChildren();
                        if (cells.size() < index) {
                            throw new IndexOutOfBoundsException("Index: " + index + " but size: " + cells.size());
                        }
                        Component cell = (Component)cells.get(index);
                        if (cell instanceof Label) {
                            String val = ((Label)cell).getValue();
                            group = new Group(val);
                        } else {
                            Component cc = cell.getFirstChild();
                            if (cc instanceof Label) {
                                String val = ((Label)cc).getValue();
                                group = new Group(val);
                            } else {
                                group = new Group(Messages.get((int)MZul.GRID_OTHER));
                            }
                        }
                        rows.appendChild((Component)group);
                    }
                    rows.appendChild((Component)row);
                    previous = row;
                }
                if (cmprx != cmpr) {
                    Column.sort0(grid, cmpr);
                }
            }
        }
        finally {
            Scopes.afterInterpret();
        }
        this.fixDirection(grid, ascending);
        grid.getRows().invalidate();
        return true;
    }

    private void groupGroupsModel(GroupsSortableModel model, Comparator cmpr, boolean ascending, int index) {
        model.group(cmpr, ascending, index);
    }

    private static void sortCollection(List<Component> comps, Comparator cmpr) {
        Collections.sort(comps, cmpr);
    }

    private static int compare(Comparator cmpr, Object a, Object b) {
        return cmpr.compare(a, b);
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"none".equals(this._sortDscNm)) {
            this.render(renderer, "sortDescending", this._sortDscNm);
        }
        if (!"none".equals(this._sortAscNm)) {
            this.render(renderer, "sortAscending", this._sortAscNm);
        }
        if (!"natural".equals(this._sortDir)) {
            this.render(renderer, "sortDirection", this._sortDir);
        }
        Utils.renderCrawlableText(this.getLabel());
    }

    public <T> T getValue() {
        return (T)this._value;
    }

    public <T> void setValue(T value) {
        this._value = value;
    }

    public void onSort(SortEvent event) {
        this.sort(event.isAscending());
    }

    public void onSort() {
        String dir = this.getSortDirection();
        if ("ascending".equals(dir)) {
            this.sort(false);
        } else if ("descending".equals(dir)) {
            this.sort(true);
        } else if (!this.sort(true)) {
            this.sort(false);
        }
    }

    public void onGroupLater(SortEvent event) {
        this.group(event.isAscending());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungroup(boolean ascending) {
        GroupToComparator cmpr;
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr != null) {
            Grid grid = this.getGrid();
            if (grid.getModel() == null) {
                Scopes.beforeInterpret((Scope)this);
                try {
                    Rows rows = grid.getRows();
                    if (rows != null) {
                        if (rows.hasGroup()) {
                            for (Group group : new ArrayList<Group>(rows.getGroups())) {
                                group.detach();
                            }
                        }
                        GroupToComparator cmprx = cmpr instanceof GroupComparator ? new GroupToComparator((GroupComparator)((Object)cmpr)) : cmpr;
                        LinkedList<Component> children = new LinkedList<Component>(rows.getChildren());
                        rows.getChildren().clear();
                        Column.sortCollection(children, cmprx);
                        for (Component c : children) {
                            rows.appendChild(c);
                        }
                    }
                }
                finally {
                    Scopes.afterInterpret();
                }
            }
            this.fixDirection(grid, ascending);
            grid.getRows().invalidate();
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-column" : this._zclass;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Columns)) {
            throw new UiException("Unsupported parent for column: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSort")) {
            SortEvent evt = SortEvent.getSortEvent((AuRequest)request);
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onGroup")) {
            Map data = request.getData();
            boolean ascending = AuRequests.getBoolean((Map)data, (String)"");
            Events.postEvent((Event)new SortEvent(cmd, (Component)this, ascending));
            Events.postEvent((int)-1000, (Event)new SortEvent("onGroupLater", (Component)this, ascending));
        } else if (cmd.equals("onUngroup")) {
            Map data = request.getData();
            boolean ascending = AuRequests.getBoolean((Map)data, (String)"");
            this.ungroup(ascending);
            Events.postEvent((Event)new SortEvent(cmd, request.getComponent(), ascending));
        } else {
            super.service(request, everError);
        }
    }

    @Override
    public Object clone() {
        Column clone = (Column)((Object)super.clone());
        clone.fixClone();
        return clone;
    }

    private void fixClone() {
        RowComparator c;
        if (this._sortAsc instanceof RowComparator && (c = (RowComparator)this._sortAsc).getColumn() == this && c.isAscending()) {
            this._sortAsc = new RowComparator(this, true, c.shallIgnoreCase(), false);
        }
        if (this._sortDsc instanceof RowComparator && (c = (RowComparator)this._sortDsc).getColumn() == this && !c.isAscending()) {
            this._sortDsc = new RowComparator(this, false, c.shallIgnoreCase(), false);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        RowComparator c;
        s.defaultWriteObject();
        boolean written = false;
        if (this._sortAsc instanceof RowComparator && (c = (RowComparator)this._sortAsc).getColumn() == this && c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortAsc);
        }
        written = false;
        if (this._sortDsc instanceof RowComparator && (c = (RowComparator)this._sortDsc).getColumn() == this && !c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortDsc);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        boolean igcs;
        s.defaultReadObject();
        boolean b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            this._sortAsc = new RowComparator(this, true, igcs, false);
        } else {
            this._sortAsc = (Comparator)s.readObject();
        }
        b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            this._sortDsc = new RowComparator(this, false, igcs, false);
        } else {
            this._sortDsc = (Comparator)s.readObject();
        }
    }

    static {
        Column.addClientEvent(Column.class, (String)"onSort", (int)8192);
        Column.addClientEvent(Column.class, (String)"onGroup", (int)8192);
        Column.addClientEvent(Column.class, (String)"onUngroup", (int)8192);
    }

    private static class GroupToComparator
    implements Comparator {
        private final GroupComparator _gcmpr;

        private GroupToComparator(GroupComparator gcmpr) {
            this._gcmpr = gcmpr;
        }

        public int compare(Object o1, Object o2) {
            return this._gcmpr.compareGroup(o1, o2);
        }
    }
}

