/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import org.zkoss.lang.Objects;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ext.Sortable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListModelSet<E>
extends AbstractListModel<E>
implements Sortable<E>,
Set<E>,
Serializable {
    private static final long serialVersionUID = 20120206122849L;
    protected Set<E> _set;
    private Comparator<E> _sorting;
    private boolean _sortDir;

    public ListModelSet(Set<E> set, boolean live) {
        this._set = live ? set : new LinkedHashSet(set);
    }

    public ListModelSet() {
        this._set = new LinkedHashSet();
    }

    public ListModelSet(Collection<? extends E> c) {
        this._set = new LinkedHashSet<E>(c);
    }

    public ListModelSet(E[] array) {
        this._set = new LinkedHashSet(array.length);
        for (int j = 0; j < array.length; ++j) {
            this._set.add(array[j]);
        }
    }

    public ListModelSet(int initialCapacity) {
        this._set = new LinkedHashSet(initialCapacity);
    }

    public ListModelSet(int initialCapacity, float loadFactor) {
        this._set = new LinkedHashSet(initialCapacity, loadFactor);
    }

    public Set<E> getInnerSet() {
        return this._set;
    }

    @Override
    public int getSize() {
        return this._set.size();
    }

    @Override
    public E getElementAt(int j) {
        E o;
        if (j < 0 || j >= this._set.size()) {
            throw new IndexOutOfBoundsException("" + j);
        }
        Iterator<E> it = this._set.iterator();
        do {
            o = it.next();
        } while (--j >= 0);
        return o;
    }

    @Override
    public boolean add(E o) {
        if (!this._set.contains(o)) {
            boolean ret = this._set.add(o);
            if (this._set instanceof LinkedHashSet) {
                int i1 = this._set.size() - 1;
                this.fireEvent(1, i1, i1);
            } else if (this._set instanceof SortedSet) {
                int i1 = this.indexOf(o);
                this.fireEvent(1, i1, i1);
            } else {
                this.fireEvent(0, -1, -1);
            }
            return ret;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this._set instanceof LinkedHashSet) {
            int begin = this._set.size();
            int added = 0;
            for (E o : c) {
                if (this._set.contains(o)) continue;
                this._set.add(o);
                ++added;
            }
            if (added > 0) {
                this.fireEvent(1, begin, begin + added - 1);
                return true;
            }
            return false;
        }
        boolean ret = this._set.addAll(c);
        this.fireEvent(0, -1, -1);
        return ret;
    }

    @Override
    public void clear() {
        int i2 = this._set.size() - 1;
        if (i2 < 0) {
            return;
        }
        this.clearSelection();
        this._set.clear();
        this.fireEvent(2, 0, i2);
    }

    @Override
    public boolean contains(Object elem) {
        return this._set.contains(elem);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._set.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return ((Object)this._set).equals(o instanceof ListModelSet ? ((ListModelSet)o)._set : o);
    }

    @Override
    public int hashCode() {
        return ((Object)this._set).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    public String toString() {
        return this._set.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Iterator<E> _it;
            private E _current;
            private int _nextIndex;
            {
                this._it = ListModelSet.this._set.iterator();
                this._current = null;
            }

            @Override
            public boolean hasNext() {
                return this._it.hasNext();
            }

            @Override
            public E next() {
                this._current = this._it.next();
                ++this._nextIndex;
                return this._current;
            }

            @Override
            public void remove() {
                this._it.remove();
                ListModelSet.this.removeFromSelection(this._current);
                --this._nextIndex;
                if (ListModelSet.this._set instanceof LinkedHashSet || ListModelSet.this._set instanceof SortedSet) {
                    ListModelSet.this.fireEvent(2, this._nextIndex, this._nextIndex);
                } else {
                    this._it.remove();
                    ListModelSet.this.fireEvent(0, -1, -1);
                }
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = false;
        if (this._set.contains(o)) {
            this.removeFromSelection(o);
            if (this._set instanceof LinkedHashSet || this._set instanceof SortedSet) {
                int index = this.indexOf(o);
                ret = this._set.remove(o);
                this.fireEvent(2, index, index);
            } else {
                ret = this._set.remove(o);
                this.fireEvent(0, -1, -1);
            }
        }
        return ret;
    }

    public int indexOf(Object o) {
        int j = 0;
        Iterator<E> it = this._set.iterator();
        while (it.hasNext()) {
            if (Objects.equals((Object)o, it.next())) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this._set == c || this == c) {
            this.clear();
            return true;
        }
        if (this._set instanceof LinkedHashSet || this._set instanceof SortedSet) {
            return this.removePartial(c, true);
        }
        this.removeAllSelection(c);
        boolean ret = this._set.removeAll(c);
        if (ret) {
            this.fireEvent(0, -1, -1);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this._set == c || this == c) {
            return false;
        }
        if (this._set instanceof LinkedHashSet || this._set instanceof SortedSet) {
            return this.removePartial(c, false);
        }
        this.retainAllSelection(c);
        boolean ret = this._set.retainAll(c);
        if (ret) {
            this.fireEvent(0, -1, -1);
        }
        return ret;
    }

    private boolean removePartial(Collection<?> c, boolean isRemove) {
        int sz = c.size();
        int removed = 0;
        int retained = 0;
        int index = 0;
        int begin = -1;
        ArrayList<E> selected = new ArrayList<E>();
        Iterator<E> it = this._set.iterator();
        while (!(!it.hasNext() || isRemove && removed >= sz || !isRemove && retained >= sz)) {
            E item = it.next();
            if (c.contains(item) == isRemove) {
                if (begin < 0) {
                    begin = index;
                }
                ++removed;
                it.remove();
                if (this._selection.contains(item)) {
                    selected.add(item);
                }
            } else {
                ++retained;
                if (begin >= 0) {
                    this.fireEvent(2, begin, index - 1);
                    index = begin;
                    begin = -1;
                }
            }
            ++index;
        }
        if (!selected.isEmpty()) {
            this.removeAllSelection(selected);
        }
        if (begin >= 0) {
            this.fireEvent(2, begin, index - 1);
        }
        return removed > 0;
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public Object[] toArray() {
        return this._set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._set.toArray(a);
    }

    @Override
    public void sort(Comparator<E> cmpr, boolean ascending) {
        ArrayList<E> copy = new ArrayList<E>(this._set);
        this._sorting = cmpr;
        this._sortDir = ascending;
        Collections.sort(copy, cmpr);
        this._set.clear();
        this._set.addAll(copy);
        this.fireEvent(3, -1, -1);
    }

    @Override
    public String getSortDirection(Comparator<E> cmpr) {
        if (Objects.equals(this._sorting, cmpr)) {
            return this._sortDir ? "ascending" : "descending";
        }
        return "natural";
    }

    @Override
    public Object clone() {
        ListModelSet clone = (ListModelSet)super.clone();
        if (this._set != null) {
            clone._set = new LinkedHashSet<E>(this._set);
        }
        return clone;
    }

    @Override
    protected void fireSelectionEvent(E e) {
        this.fireEvent(4, this.indexOf(e), -1);
    }

    public void addSelection(E obj) {
        this.addToSelection(obj);
    }

    public void removeSelection(Object obj) {
        this.removeFromSelection(obj);
    }
}

