/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.PageCtrl;

public class PageRenderer
implements org.zkoss.zk.ui.sys.PageRenderer {
    public void render(Page page, Writer out) throws IOException {
        Execution exec = Executions.getCurrent();
        String ctl = ExecutionsCtrl.getPageRedrawControl((Execution)exec);
        boolean au = exec.isAsyncUpdate(null);
        if (!au && (page.isComplete() || "complete".equals(ctl))) {
            this.renderComplete(exec, page, out);
            return;
        }
        boolean pageOnly = au;
        if (!pageOnly) {
            boolean bl = pageOnly = (exec.isIncluded() || "page".equals(ctl)) && !"desktop".equals(ctl);
        }
        if (pageOnly) {
            this.renderPage(exec, page, out, au);
        } else {
            this.renderDesktop(exec, page, out);
        }
    }

    protected void renderDesktop(Execution exec, Page page, Writer out) throws IOException {
        HtmlPageRenders.setContentType((Execution)exec, (Page)page);
        PageCtrl pageCtrl = (PageCtrl)page;
        PageRenderer.write(out, HtmlPageRenders.outFirstLine((Execution)exec, (Page)page));
        PageRenderer.write(out, HtmlPageRenders.outDocType((Execution)exec, (Page)page));
        Double number = exec.getBrowser("mobile");
        out.write("<html");
        if (number == null || number.intValue() == 0) {
            Double ie = exec.getBrowser("ie");
            if (ie != null && ie < 9.0) {
                out.write(" xmlns:v=\"urn:schemas-microsft.com:vml\"");
            }
            PageRenderer.write(out, pageCtrl.getRootAttributes());
            out.write(">\n<head>\n<title>");
        } else {
            PageRenderer.write(out, pageCtrl.getRootAttributes());
            out.write(">\n<head>\n");
            String viewport = page.getViewport();
            if (!"auto".equals(viewport)) {
                out.write("<meta name=\"viewport\" content=\"" + viewport + "\" > \n");
            } else if (!"true".equals(Library.getProperty((String)"org.zkoss.zul.tablet.meta.viewport.disabled", (String)"false"))) {
                out.write("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no\" > \n");
            }
            out.write("<title>");
        }
        PageRenderer.write(out, page.getTitle());
        out.write("</title>\n");
        PageRenderer.outHeaders(exec, page, out);
        out.write("</head>\n");
        out.write("<body>\n");
        HtmlPageRenders.outPageContent((Execution)exec, (Page)page, (Writer)out, (boolean)false);
        PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
        out.write("\n</body>\n</html>\n");
    }

    private static void outHeaders(Execution exec, Page page, Writer out) throws IOException {
        out.write(HtmlPageRenders.outHeaders((Execution)exec, (Page)page, (boolean)true));
        out.write(HtmlPageRenders.outLangStyleSheets((Execution)exec, null, null));
        out.write(HtmlPageRenders.outLangJavaScripts((Execution)exec, null, null));
        out.write(HtmlPageRenders.outHeaders((Execution)exec, (Page)page, (boolean)false));
    }

    private static void write(Writer out, String s) throws IOException {
        if (s != null) {
            out.write(s);
        }
    }

    private static void writeln(Writer out, String s) throws IOException {
        if (s != null) {
            out.write(s);
            out.write(10);
        }
    }

    protected void renderPage(Execution exec, Page page, Writer out, boolean au) throws IOException {
        if (!au) {
            out.write(HtmlPageRenders.outLangStyleSheets((Execution)exec, null, null));
            out.write(HtmlPageRenders.outLangJavaScripts((Execution)exec, null, null));
        }
        HtmlPageRenders.outPageContent((Execution)exec, (Page)page, (Writer)out, (boolean)au);
        if (!au && ((PageCtrl)page).getOwner() == null) {
            PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
        }
    }

    protected void renderComplete(Execution exec, Page page, Writer out) throws IOException {
        PageRenderer.write(out, HtmlPageRenders.outFirstLine((Execution)exec, (Page)page));
        PageRenderer.write(out, HtmlPageRenders.outDocType((Execution)exec, (Page)page));
        HtmlPageRenders.setContentType((Execution)exec, (Page)page);
        for (Component root = page.getFirstRoot(); root != null; root = root.getNextSibling()) {
            ((ComponentCtrl)root).redraw(out);
        }
        PageRenderer.write(out, HtmlPageRenders.outHeaderZkTags((Execution)exec, (Page)page));
        PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
    }
}

