/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.lang.ref.WeakReference;
import pl.droidsonroids.gif.AnimationListener;
import pl.droidsonroids.gif.GifDrawable;

class InvalidationHandler
extends Handler {
    static final int MSG_TYPE_INVALIDATION = -1;
    private final WeakReference<GifDrawable> mDrawableRef;

    public InvalidationHandler(GifDrawable gifDrawable) {
        super(Looper.getMainLooper());
        this.mDrawableRef = new WeakReference<GifDrawable>(gifDrawable);
    }

    public void handleMessage(Message msg) {
        GifDrawable gifDrawable = (GifDrawable)((Object)this.mDrawableRef.get());
        if (gifDrawable == null) {
            return;
        }
        if (msg.what == -1) {
            gifDrawable.invalidateSelf();
        } else {
            for (AnimationListener listener : gifDrawable.mListeners) {
                listener.onAnimationCompleted(msg.what);
            }
        }
    }
}

