/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.timeseries;

import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.timeseries.DuplicatePolicy;
import redis.clients.jedis.timeseries.TimeSeriesProtocol;

public class TSCreateParams
implements IParams {
    private Long retentionTime;
    private boolean uncompressed;
    private boolean compressed;
    private Long chunkSize;
    private DuplicatePolicy duplicatePolicy;
    private Map<String, String> labels;

    public static TSCreateParams createParams() {
        return new TSCreateParams();
    }

    public TSCreateParams retention(long retentionTime) {
        this.retentionTime = retentionTime;
        return this;
    }

    public TSCreateParams uncompressed() {
        this.uncompressed = true;
        return this;
    }

    public TSCreateParams compressed() {
        this.compressed = true;
        return this;
    }

    public TSCreateParams chunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public TSCreateParams duplicatePolicy(DuplicatePolicy duplicatePolicy) {
        this.duplicatePolicy = duplicatePolicy;
        return this;
    }

    public TSCreateParams labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.retentionTime != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.RETENTION).add(Protocol.toByteArray(this.retentionTime));
        }
        if (this.uncompressed) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.ENCODING).add(TimeSeriesProtocol.TimeSeriesKeyword.UNCOMPRESSED);
        } else if (this.compressed) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.ENCODING).add(TimeSeriesProtocol.TimeSeriesKeyword.COMPRESSED);
        }
        if (this.chunkSize != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.CHUNK_SIZE).add(Protocol.toByteArray(this.chunkSize));
        }
        if (this.duplicatePolicy != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.DUPLICATE_POLICY).add(this.duplicatePolicy);
        }
        if (this.labels != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.LABELS);
            this.labels.entrySet().forEach(entry -> args.add(entry.getKey()).add(entry.getValue()));
        }
    }
}

