/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.jofc2.model.elements;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import ro.nextreports.jofc2.model.elements.Element;
import ro.nextreports.jofc2.model.elements.NullElement;
import ro.nextreports.jofc2.model.metadata.Converter;
import ro.nextreports.jofc2.util.HorizontalBarChartBarConverter;

public class HorizontalBarChart
extends Element {
    private static final long serialVersionUID = 3320580794787784639L;
    private String colour;

    public HorizontalBarChart() {
        super("hbar");
    }

    public String getColour() {
        return this.colour;
    }

    public HorizontalBarChart setColour(String colour) {
        this.colour = colour;
        return this;
    }

    public HorizontalBarChart addBars(Bar ... bars) {
        this.getValues().addAll(Arrays.asList(bars));
        return this;
    }

    public HorizontalBarChart addBars(List<Bar> bars) {
        this.getValues().addAll(bars);
        return this;
    }

    public HorizontalBarChart addValues(Number ... rightValues) {
        return this.addValues(Arrays.asList(rightValues));
    }

    public HorizontalBarChart addValues(List<Number> rightValues) {
        for (Number number : rightValues) {
            if (number != null) {
                this.getValues().add(new Bar(number));
                continue;
            }
            this.getValues().add(new NullElement());
        }
        return this;
    }

    public HorizontalBarChart addBar(Number left, Number right) {
        return this.addBars(new Bar(left, right));
    }

    @Converter(value=HorizontalBarChartBarConverter.class)
    public static class Bar
    implements Serializable {
        private static final long serialVersionUID = 3148075877503179797L;
        private final Number right;
        private Number left;
        private String tooltip = "";

        public Bar(Number right) {
            this(null, right);
        }

        public Bar(Number left, Number right) {
            if (right == null) {
                throw new NullPointerException("Field is mandatory.");
            }
            this.right = right;
            this.setLeft(left);
        }

        public Number getRight() {
            return this.right;
        }

        public Number getLeft() {
            return this.left;
        }

        public Bar setLeft(Number left) {
            this.left = left;
            return this;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }
    }
}

