/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.jofc2.model.elements;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import ro.nextreports.jofc2.model.elements.AnimatedElement;
import ro.nextreports.jofc2.model.elements.NullElement;
import ro.nextreports.jofc2.model.metadata.Alias;
import ro.nextreports.jofc2.model.metadata.Converter;
import ro.nextreports.jofc2.util.DotConverter;
import ro.nextreports.jofc2.util.TypeDotConverter;

public class LineChart
extends AnimatedElement {
    private static final long serialVersionUID = 8807130855547088579L;
    private static final transient Integer DEFAULT_FONTSIZE = 10;
    private Integer width;
    @Alias(value="dot-size")
    private Integer dotSize;
    @Alias(value="halo-size")
    private Integer haloSize;
    private String colour;
    private String axis;
    @Alias(value="dot-style")
    private Style dotStyle = new Style(Style.Type.SOLID_DOT);

    public String getYaxis() {
        return this.axis;
    }

    public void setYAxis(String yAxis) {
        this.axis = yAxis;
    }

    public void setRightYAxis() {
        this.setYAxis("right");
    }

    public LineChart() {
        this("line");
    }

    public LineChart(Style dotStyle) {
        this();
        this.setDotStyle(dotStyle);
    }

    protected LineChart(String type) {
        super(type);
        this.setFontSize(DEFAULT_FONTSIZE);
    }

    public Integer getWidth() {
        return this.width;
    }

    public LineChart setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getDotSize() {
        return this.dotSize;
    }

    public LineChart setDotSize(Integer dotSize) {
        this.dotSize = dotSize;
        return this;
    }

    public String getColour() {
        return this.colour;
    }

    public LineChart setColour(String colour) {
        this.colour = colour;
        return this;
    }

    public LineChart addValues(Number ... values) {
        return this.addValues(Arrays.asList(values));
    }

    public LineChart addValues(List<Number> values) {
        for (Number number : values) {
            if (number == null) {
                this.getValues().add(new NullElement());
                continue;
            }
            this.getValues().add(number);
        }
        return this;
    }

    public LineChart addDots(Dot ... dots) {
        return this.addDots(Arrays.asList(dots));
    }

    public LineChart addDots(List<Dot> dots) {
        for (Dot dot : dots) {
            if (dot == null || dot.getValue() == null) {
                this.getValues().add(new NullElement());
                continue;
            }
            this.getValues().add(dot);
        }
        return this;
    }

    public Integer getHaloSize() {
        return this.haloSize;
    }

    public LineChart setHaloSize(Integer haloSize) {
        this.haloSize = haloSize;
        return this;
    }

    public Style getDotStyle() {
        return this.dotStyle;
    }

    public LineChart setDotStyle(Style dotStyle) {
        this.dotStyle = dotStyle;
        return this;
    }

    @Converter(value=TypeDotConverter.class)
    public static class Style
    implements Serializable {
        private static final long serialVersionUID = 7167564063732384112L;
        private String type = "solid-dot";
        private Integer rotation = 90;
        private Boolean hallow = false;
        @Alias(value="halo-size")
        private Integer haloSize = 2;
        @Alias(value="dot-size")
        private Integer dotSize = 2;
        private String colour;
        private Integer sides = 2;

        public Style(Type type, String colour) {
            this(type, colour, 2, 2, null, null);
        }

        public Style(Type type) {
            this(type, null, 2, 2, null, null);
        }

        public Style(Type type, String colour, Integer dotSize, Integer haloSize) {
            this(type, colour, dotSize, haloSize, null, null);
        }

        public Style(Type type, String colour, Integer dotSize, Integer haloSize, Integer rotation, Boolean hallow) {
            if (Type.HALLOW_DOT == type) {
                this.setType(Type.HALLOW_DOT.getType());
                this.setColour(colour);
                this.setDotSize(dotSize);
                this.setHaloSize(haloSize);
                this.setRotation(null);
                this.setSides(null);
                this.setHallow(null);
            } else if (Type.ANCHOR == type) {
                this.setType(Type.ANCHOR.getType());
                this.setColour(colour);
                this.setDotSize(dotSize);
                this.setHaloSize(haloSize);
                this.setRotation(rotation);
                this.setSides(this.sides);
                this.setHallow(null);
            } else if (Type.STAR == type) {
                this.setType(Type.STAR.getType());
                this.setColour(colour);
                this.setDotSize(dotSize);
                this.setHaloSize(haloSize);
                this.setRotation(rotation);
                this.setHallow(hallow);
                this.setSides(null);
            } else if (Type.SOLID_DOT == type) {
                this.setType(Type.SOLID_DOT.getType());
                this.setColour(colour);
                this.setDotSize(dotSize);
                this.setHaloSize(haloSize);
                this.setRotation(null);
                this.setSides(null);
                this.setHallow(null);
            } else if (Type.BOW == type) {
                this.setType(Type.BOW.getType());
                this.setColour(colour);
                this.setDotSize(dotSize);
                this.setHaloSize(haloSize);
                this.setRotation(rotation);
                this.setSides(null);
                this.setHallow(null);
            }
        }

        public Integer getHaloSize() {
            return this.haloSize;
        }

        public Style setHaloSize(Integer haloSize) {
            this.haloSize = haloSize;
            return this;
        }

        public Integer getDotSize() {
            return this.dotSize;
        }

        public Style setDotSize(Integer dotSize) {
            this.dotSize = dotSize;
            return this;
        }

        public String getColour() {
            return this.colour;
        }

        public Style setColour(String colour) {
            this.colour = colour;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Style setType(String type) {
            this.type = type;
            return this;
        }

        public Integer getRotation() {
            return this.rotation;
        }

        public Style setRotation(Integer rotation) {
            this.rotation = rotation;
            return this;
        }

        public Boolean getHallow() {
            return this.hallow;
        }

        public Style setHallow(Boolean hallow) {
            this.hallow = hallow;
            return this;
        }

        public Integer getSides() {
            return this.sides;
        }

        public Style setSides(Integer sides) {
            this.sides = sides;
            return this;
        }

        public static enum Type {
            BOW("bow"),
            DOT("dot"),
            HALLOW_DOT("hollow-dot"),
            ANCHOR("anchor"),
            STAR("star"),
            SOLID_DOT("solid-dot");

            private String type;

            private Type(String type) {
                this.type = type;
            }

            public String getType() {
                return this.type;
            }
        }
    }

    @Converter(value=DotConverter.class)
    public static class Dot
    implements Serializable {
        @Alias(value="halo-size")
        private Integer haloSize;
        @Alias(value="dot-size")
        private Integer dotSize;
        private Number value;
        private String colour;
        @Alias(value="tip")
        private String tooltip;
        @Alias(value="on-click")
        private String onClick;

        public String getOnClick() {
            return this.onClick;
        }

        public void setOnClick(String onClick) {
            this.onClick = onClick;
        }

        public Dot(Number value) {
            this(value, null, null, null);
        }

        public Dot(Number value, String colour) {
            this(value, colour, null, null);
        }

        public Dot(Number value, String colour, Integer dotSize, Integer haloSize) {
            this.setValue(value);
            this.setColour(colour);
            this.setDotSize(dotSize);
            this.setHaloSize(haloSize);
        }

        public Integer getHaloSize() {
            return this.haloSize;
        }

        public Dot setHaloSize(Integer haloSize) {
            this.haloSize = haloSize;
            return this;
        }

        public Integer getDotSize() {
            return this.dotSize;
        }

        public Dot setDotSize(Integer dotSize) {
            this.dotSize = dotSize;
            return this;
        }

        public Number getValue() {
            return this.value;
        }

        public Dot setValue(Number value) {
            this.value = value;
            return this;
        }

        public String getColour() {
            return this.colour;
        }

        public Dot setColour(String colour) {
            this.colour = colour;
            return this;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }
    }
}

