/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.jofc2.model.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import ro.nextreports.jofc2.model.elements.Element;
import ro.nextreports.jofc2.model.metadata.Alias;
import ro.nextreports.jofc2.model.metadata.Converter;
import ro.nextreports.jofc2.util.PieChartSliceConverter;

public class PieChart
extends Element {
    private static final long serialVersionUID = 8853434988212173862L;
    @Alias(value="start-angle")
    private Integer startAngle;
    private Collection<String> colours;
    private List<Object> animate = new ArrayList<Object>();
    private Integer border;
    private Integer radius;
    @Alias(value="no-labels")
    private Boolean noLabels;

    public PieChart() {
        super("pie");
    }

    public Integer getStartAngle() {
        return this.startAngle;
    }

    public PieChart setStartAngle(Integer startAngle) {
        this.startAngle = startAngle;
        return this;
    }

    public Collection<String> getColours() {
        return this.colours;
    }

    public PieChart setColours(Collection<String> colours) {
        this.checkColours();
        this.colours = colours;
        return this;
    }

    public PieChart setColours(String ... colours) {
        this.checkColours();
        this.colours.addAll(Arrays.asList(colours));
        return this;
    }

    public PieChart setColours(List<String> colours) {
        this.checkColours();
        this.colours.addAll(colours);
        return this;
    }

    public Integer getBorder() {
        return this.border;
    }

    public PieChart setBorder(Integer border) {
        this.border = border;
        return this;
    }

    public PieChart addValues(Number ... values) {
        this.getValues().addAll(Arrays.asList(values));
        return this;
    }

    public PieChart addValues(List<Number> values) {
        for (Number number : values) {
            if (number == null) continue;
            this.getValues().add(number);
        }
        return this;
    }

    public PieChart addSlice(Number value, String text) {
        return this.addSlices(new Slice(value, text));
    }

    public PieChart addSlices(Slice ... s) {
        this.getValues().addAll(Arrays.asList(s));
        return this;
    }

    public PieChart addSlices(List<Slice> values) {
        this.getValues().addAll(values);
        return this;
    }

    public void setAnimate(boolean _animate) {
        if (_animate && this.getAnimate().size() == 0) {
            this.getAnimate().add(new AnimationPie.Fade());
        }
    }

    public PieChart addAnimations(AnimationPie ... animations) {
        return this.addAnimations(Arrays.asList(animations));
    }

    public PieChart addAnimations(List<AnimationPie> animations) {
        this.getAnimate().addAll(animations);
        return this;
    }

    private synchronized void checkColours() {
        if (this.colours == null) {
            this.colours = new ArrayList<String>();
        }
    }

    public Boolean getNoLabels() {
        return this.noLabels;
    }

    public void setNoLabels(Boolean noLabels) {
        this.noLabels = noLabels;
    }

    public Integer getRadius() {
        return this.radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    private List<Object> getAnimate() {
        return this.animate;
    }

    public static abstract class AnimationPie {
        private String type;
        private Integer distance;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getDistance() {
            return this.distance;
        }

        public void setDistance(Integer distance) {
            this.distance = distance;
        }

        public static class Bounce
        extends AnimationPie
        implements Serializable {
            private static final long serialVersionUID = -2951410274832180986L;

            public Bounce(Integer distance) {
                this.setType("bounce");
                this.setDistance(distance);
            }
        }

        public static class Fade
        extends AnimationPie
        implements Serializable {
            private static final long serialVersionUID = -3878420396240140754L;

            public Fade() {
                this.setType("fade");
            }
        }
    }

    @Converter(value=PieChartSliceConverter.class)
    public static class Slice
    implements Serializable {
        private static final long serialVersionUID = 6961394996186973937L;
        private final String label;
        private String tip;
        private String highlight = "alpha";
        private String text;
        private final Number value;
        private String onClick;

        public Slice(Number value, String label) {
            this.label = label;
            this.value = value;
            this.text = label;
        }

        public void setOnMouseOverAlpha() {
            this.highlight = "alpha";
        }

        public void setOnMouseOverBreakout() {
            this.highlight = null;
        }

        public Number getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getText() {
            return this.text;
        }

        public String getTip() {
            return this.tip;
        }

        public void setTip(String tip) {
            this.tip = tip;
        }

        public String getHighlight() {
            return this.highlight;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getOnClick() {
            return this.onClick;
        }

        public void setOnClick(String onClick) {
            this.onClick = onClick;
        }
    }
}

