/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.jofc2.model.elements;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import ro.nextreports.jofc2.model.elements.AnimatedElement;
import ro.nextreports.jofc2.model.metadata.Alias;
import ro.nextreports.jofc2.model.metadata.Converter;
import ro.nextreports.jofc2.util.ScatterChartPointConverter;

public class ScatterChart
extends AnimatedElement {
    private static final String TYPE = "scatter";
    private static final long serialVersionUID = 3029567780918048503L;
    private String colour;
    @Alias(value="dot-size")
    private Integer dotSize;

    public ScatterChart() {
        super(TYPE);
    }

    public ScatterChart(Style style) {
        super(style.getStyle());
    }

    public ScatterChart addPoints(Point ... points) {
        this.getValues().addAll(Arrays.asList(points));
        return this;
    }

    public ScatterChart addPoint(Number x, Number y) {
        return this.addPoints(new Point(x, y));
    }

    public ScatterChart addPoints(Collection<Point> points) {
        this.getValues().addAll(points);
        return this;
    }

    public String getColour() {
        return this.colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }

    public Integer getDotSize() {
        return this.dotSize;
    }

    public void setDotSize(Integer dotSize) {
        this.dotSize = dotSize;
    }

    public static enum Style {
        NORMAL("scatter"),
        LINE("scatter_line");

        private String style;

        private Style(String style) {
            this.style = style;
        }

        public String getStyle() {
            return this.style;
        }
    }

    @Converter(value=ScatterChartPointConverter.class)
    public static class Point
    implements Serializable {
        private Number x;
        private Number y;

        public Point(Number x, Number y) {
            this.x = x;
            this.y = y;
        }

        public Number getX() {
            return this.x;
        }

        public void setX(Number x) {
            this.x = x;
        }

        public Number getY() {
            return this.y;
        }

        public void setY(Number y) {
            this.y = y;
        }
    }
}

