/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.groovy;

import groovy.text.Template;
import groovy.text.markup.MarkupTemplateEngine;
import groovy.text.markup.TemplateConfiguration;
import groovy.text.markup.TemplateResolver;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.AbstractTemplateEngine;
import ro.pippo.core.Application;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.util.StringUtils;
import ro.pippo.groovy.GroovyTemplateResolver;
import ro.pippo.groovy.PippoGroovyTemplate;

public class GroovyTemplateEngine
extends AbstractTemplateEngine {
    private static final Logger log = LoggerFactory.getLogger(GroovyTemplateEngine.class);
    public static final String GROOVY = "groovy";
    private MarkupTemplateEngine engine;

    public void init(Application application) {
        super.init(application);
        PippoSettings pippoSettings = this.getPippoSettings();
        TemplateConfiguration configuration = new TemplateConfiguration();
        configuration.setBaseTemplateClass(PippoGroovyTemplate.class);
        configuration.setAutoEscape(true);
        if (pippoSettings.isDev()) {
            configuration.setCacheTemplates(false);
        } else {
            configuration.setAutoIndent(true);
            configuration.setAutoNewLine(true);
            configuration.setAutoIndentString("  ");
        }
        String pathPrefix = this.getTemplatePathPrefix();
        pathPrefix = StringUtils.removeStart((String)pathPrefix, (String)"/");
        pathPrefix = StringUtils.removeEnd((String)pathPrefix, (String)"/");
        GroovyTemplateResolver cachingResolver = new GroovyTemplateResolver(pathPrefix);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.init(application, configuration);
        this.engine = new MarkupTemplateEngine(classLoader, configuration, (TemplateResolver)cachingResolver);
    }

    protected String getDefaultFileExtension() {
        return GROOVY;
    }

    public void renderString(String templateContent, Map<String, Object> model, Writer writer) {
        try {
            Template groovyTemplate = this.engine.createTemplate(templateContent);
            PippoGroovyTemplate gt = (PippoGroovyTemplate)groovyTemplate.make(model);
            gt.setup(this.getLanguages(), this.getMessages(), this.getRouter());
            gt.writeTo(writer);
        }
        catch (Exception e) {
            log.error("Error processing Groovy template {} ", (Object)templateContent, (Object)e);
            throw new PippoRuntimeException((Throwable)e);
        }
    }

    public void renderResource(String templateName, Map<String, Object> model, Writer writer) {
        Template groovyTemplate;
        if (templateName.indexOf(46) == -1) {
            templateName = templateName + "." + this.getFileExtension();
        }
        try {
            groovyTemplate = this.engine.createTemplateByPath(templateName);
        }
        catch (IOException | ClassNotFoundException | RuntimeException e) {
            log.error("Error reading Groovy template {} ", (Object)templateName, (Object)e);
            throw new PippoRuntimeException((Throwable)e);
        }
        try {
            PippoGroovyTemplate gt = (PippoGroovyTemplate)groovyTemplate.make(model);
            gt.setup(this.getLanguages(), this.getMessages(), this.getRouter());
            gt.writeTo(writer);
        }
        catch (Exception e) {
            log.error("Error processing Groovy template {} ", (Object)templateName, (Object)e);
            throw new PippoRuntimeException((Throwable)e);
        }
    }

    protected void init(Application application, TemplateConfiguration configuration) {
    }
}

