/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.groovy;

import groovy.text.markup.MarkupTemplateEngine;
import groovy.text.markup.TemplateConfiguration;
import groovy.text.markup.TemplateResolver;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ro.pippo.core.util.ClasspathUtils;

public class GroovyTemplateResolver
implements TemplateResolver {
    private TemplateConfiguration templateConfiguration;
    protected final String pathPrefix;
    protected final Map<String, URL> cache;
    protected boolean useCache = false;

    public GroovyTemplateResolver(String pathPrefix, Map<String, URL> cache) {
        this.pathPrefix = pathPrefix;
        this.cache = cache;
    }

    public GroovyTemplateResolver(String pathPrefix) {
        this(pathPrefix, new ConcurrentHashMap<String, URL>());
    }

    public void configure(ClassLoader templateClassLoader, TemplateConfiguration configuration) {
        this.templateConfiguration = configuration;
        this.useCache = configuration.isCacheTemplates();
    }

    public URL resolveTemplate(String templatePath) throws IOException {
        URL resource;
        String path = this.pathPrefix == null ? templatePath : this.pathPrefix + "/" + templatePath;
        MarkupTemplateEngine.TemplateResource templateResource = MarkupTemplateEngine.TemplateResource.parse((String)path);
        String configurationLocale = this.templateConfiguration.getLocale().toString().replace("-", "_");
        URL uRL = resource = templateResource.hasLocale() ? this.getResource(templateResource.toString()) : null;
        if (resource == null) {
            resource = this.getResource(templateResource.withLocale(configurationLocale).toString());
        }
        if (resource == null) {
            resource = this.getResource(templateResource.withLocale(null).toString());
        }
        if (resource == null) {
            throw new IOException("Unable to load template:" + path);
        }
        if (this.useCache) {
            this.cache.put(templatePath, resource);
        }
        return resource;
    }

    protected URL getResource(String templatePath) {
        URL cachedURL;
        if (this.useCache && (cachedURL = this.cache.get(templatePath)) != null) {
            return cachedURL;
        }
        URL resource = ClasspathUtils.locateOnClasspath((String)templatePath);
        return resource;
    }
}

