/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.groovy;

import groovy.text.markup.BaseTemplate;
import groovy.text.markup.MarkupTemplateEngine;
import groovy.text.markup.TemplateConfiguration;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.ocpsoft.prettytime.PrettyTime;
import ro.pippo.core.Languages;
import ro.pippo.core.Messages;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.route.ClasspathResourceHandler;
import ro.pippo.core.route.PublicResourceHandler;
import ro.pippo.core.route.Router;
import ro.pippo.core.route.WebjarsResourceHandler;
import ro.pippo.core.util.StringUtils;

public abstract class PippoGroovyTemplate
extends BaseTemplate {
    private final Map<String, String> modelTypes;
    private final MarkupTemplateEngine engine;
    Router router;
    String language;
    Locale locale;
    Languages languages;
    Messages messages;
    PrettyTime prettyTime;
    AtomicReference<String> webjarsPatternRef;
    AtomicReference<String> publicPatternRef;

    public PippoGroovyTemplate(MarkupTemplateEngine templateEngine, Map model, Map<String, String> modelTypes, TemplateConfiguration configuration) {
        super(templateEngine, model, modelTypes, configuration);
        this.modelTypes = modelTypes;
        this.engine = templateEngine;
        this.webjarsPatternRef = new AtomicReference();
        this.publicPatternRef = new AtomicReference();
    }

    public void setup(Languages languages, Messages messages, Router router) {
        this.languages = languages;
        this.messages = messages;
        this.router = router;
        this.getModel().put("contextPath", router.getContextPath());
        this.getModel().put("appPath", router.getApplicationPath());
        String language = (String)this.getModel().get("lang");
        if (StringUtils.isNullOrEmpty((String)language)) {
            language = languages.getLanguageOrDefault(language);
        }
        this.language = language;
        Locale locale = (Locale)this.getModel().get("locale");
        if (locale == null) {
            locale = languages.getLocaleOrDefault(language);
        }
        this.locale = locale;
    }

    public void ln() throws IOException {
        this.newLine();
    }

    public String webjarsAt(String path) {
        return this.classpathResourceAt(path, this.webjarsPatternRef, WebjarsResourceHandler.class);
    }

    public String publicAt(String path) {
        return this.classpathResourceAt(path, this.publicPatternRef, PublicResourceHandler.class);
    }

    private String classpathResourceAt(String path, AtomicReference<String> patternRef, Class<? extends ClasspathResourceHandler> resourceHandlerClass) {
        if (patternRef.get() == null) {
            String pattern = this.router.uriPatternFor(resourceHandlerClass);
            if (pattern == null) {
                throw new PippoRuntimeException("You must register a route for {}", new Object[]{resourceHandlerClass.getSimpleName()});
            }
            patternRef.set(pattern);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("path", path);
        return this.router.uriFor(patternRef.get(), parameters);
    }

    public String i18n(String messageKey) throws IOException {
        return this.messages.get(messageKey, this.language, new Object[0]);
    }

    public String i18n(String messageKey, Object ... args) throws IOException {
        return this.messages.get(messageKey, this.language, args);
    }

    public String formatTime(Object input, String styleOrPattern) {
        Date date = this.getDateObject(input);
        int type = this.parseStyle(styleOrPattern);
        DateFormat df = type == -1 ? new SimpleDateFormat(styleOrPattern, this.locale) : DateFormat.getDateTimeInstance(type, type, this.locale);
        return df.format(date);
    }

    private Date getDateObject(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        throw new PippoRuntimeException("Failed to get a date object from {}!", new Object[]{value});
    }

    protected Integer parseStyle(String style) {
        if ("full".equals(style)) {
            return 0;
        }
        if ("long".equals(style)) {
            return 1;
        }
        if ("short".equals(style)) {
            return 3;
        }
        if ("medium".equals(style)) {
            return 2;
        }
        return -1;
    }

    public String prettyTime(Object input) {
        if (this.prettyTime == null) {
            this.prettyTime = new PrettyTime(this.locale);
        }
        Date date = this.getDateObject(input);
        return this.prettyTime.format(date);
    }

    public String ng(String content) throws IOException {
        return "{{ " + content + " }}";
    }

    public Object layout(Map model, String templateName, boolean inheritModel) throws IOException, ClassNotFoundException {
        Map submodel = inheritModel ? this.forkModel(model) : model;
        URL resource = this.engine.resolveTemplate(templateName);
        PippoGroovyTemplate template = (PippoGroovyTemplate)this.engine.createTypeCheckedModelTemplate(resource, this.modelTypes).make(submodel);
        template.setup(this.languages, this.messages, this.router);
        template.writeTo(this.getOut());
        return this;
    }

    private Map forkModel(Map m) {
        HashMap result = new HashMap();
        result.putAll(this.getModel());
        result.putAll(m);
        return result;
    }
}

