/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.less4j;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.route.ClasspathResourceHandler;
import ro.pippo.core.route.RouteContext;

public class LessResourceHandler
extends ClasspathResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(LessResourceHandler.class);
    private boolean minify;
    private Map<String, String> sourceMap = new ConcurrentHashMap<String, String>();

    public LessResourceHandler(String urlPath, String resourceBasePath) {
        super(urlPath, resourceBasePath);
    }

    public LessResourceHandler useMinimized(boolean minimized) {
        this.minify = minimized;
        return this;
    }

    protected void sendResource(URL resourceUrl, RouteContext routeContext) throws IOException {
        try {
            log.trace("Send css for '{}'", (Object)resourceUrl);
            LessSource.URLSource source = new LessSource.URLSource(resourceUrl);
            String content = source.getContent();
            String result = this.sourceMap.get(content);
            if (result == null) {
                ThreadUnsafeLessCompiler compiler = new ThreadUnsafeLessCompiler();
                LessCompiler.Configuration configuration = new LessCompiler.Configuration();
                configuration.setCompressing(this.minify);
                LessCompiler.CompilationResult compilationResult = compiler.compile(resourceUrl, configuration);
                for (LessCompiler.Problem warning : compilationResult.getWarnings()) {
                    log.warn("Line: {}, Character: {}, Message: {} ", new Object[]{warning.getLine(), warning.getCharacter(), warning.getMessage()});
                }
                result = compilationResult.getCss();
                if (routeContext.getApplication().getPippoSettings().isProd()) {
                    this.sourceMap.put(content, result);
                }
            }
            routeContext.getResponse().contentType("text/css");
            routeContext.getResponse().ok().send((CharSequence)result);
        }
        catch (Exception e) {
            throw new PippoRuntimeException((Throwable)e);
        }
    }
}

