/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import ro.pippo.controller.Controller;
import ro.pippo.controller.ControllerFactory;

public class SpringControllerFactory
implements ControllerFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringControllerFactory.class);
    private ApplicationContext applicationContext;
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private boolean autoRegistering;

    public SpringControllerFactory(ApplicationContext applicationContext) {
        this(applicationContext, true);
    }

    public SpringControllerFactory(ApplicationContext applicationContext, boolean autoRegistering) {
        this.applicationContext = applicationContext;
        this.autoRegistering = autoRegistering;
        if (autoRegistering) {
            this.beanDefinitionRegistry = (BeanDefinitionRegistry)applicationContext.getAutowireCapableBeanFactory();
        }
    }

    public <T extends Controller> T createController(Class<T> controllerClass) {
        String beanName = controllerClass.getName();
        if (this.autoRegistering && !this.beanDefinitionRegistry.containsBeanDefinition(beanName)) {
            log.debug("Create bean definition for '{}'", (Object)beanName);
            BeanDefinition definition = this.createBeanDefinition(controllerClass);
            log.debug("Register '{}' as bean", (Object)beanName);
            this.beanDefinitionRegistry.registerBeanDefinition(beanName, definition);
        }
        return (T)((Controller)this.applicationContext.getBean(controllerClass));
    }

    protected BeanDefinition createBeanDefinition(Class<? extends Controller> controllerClass) {
        return new RootBeanDefinition(controllerClass, Autowire.BY_TYPE.value(), true);
    }
}

