/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.AbstractWebServer;
import ro.pippo.core.Application;
import ro.pippo.core.PippoFilter;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.PippoServletContextListener;
import ro.pippo.undertow.UndertowSettings;
import ro.pippo.undertow.websocket.UndertowWebSocketFilter;

public class UndertowServer
extends AbstractWebServer<UndertowSettings> {
    private static final Logger log = LoggerFactory.getLogger(UndertowServer.class);
    private Undertow server;
    private DeploymentManager pippoDeploymentManager;

    public void start() {
        try {
            this.pippoDeploymentManager = this.createPippoDeploymentManager();
            HttpHandler pippoHandler = this.pippoDeploymentManager.start();
            HttpHandler contextHandler = this.createContextHandler(pippoHandler);
            GracefulShutdownHandler rootHandler = new GracefulShutdownHandler(contextHandler);
            this.server = this.createServer((HttpHandler)rootHandler);
            String version = this.server.getClass().getPackage().getImplementationVersion();
            log.info("Starting Undertow Server {} on port {}", (Object)version, (Object)((UndertowSettings)this.getSettings()).getPort());
            this.server.start();
        }
        catch (Exception e) {
            throw new PippoRuntimeException((Throwable)e);
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                String version = this.server.getClass().getPackage().getImplementationVersion();
                log.info("Stopping Undertow {} on port {}", (Object)version, (Object)((UndertowSettings)this.getSettings()).getPort());
                this.server.stop();
                this.pippoDeploymentManager.undeploy();
            }
            catch (Exception e) {
                throw new PippoRuntimeException((Throwable)e, "Cannot stop Undertow Server", new Object[0]);
            }
        }
    }

    protected UndertowSettings createDefaultSettings() {
        return new UndertowSettings(this.getApplication().getPippoSettings());
    }

    protected Undertow createServer(HttpHandler contextHandler) {
        Undertow.Builder builder = Undertow.builder();
        if (((UndertowSettings)this.getSettings()).getBufferSize() > 0) {
            builder.setBufferSize(((UndertowSettings)this.getSettings()).getBufferSize());
        }
        if (((UndertowSettings)this.getSettings()).getDirectBuffers()) {
            builder.setDirectBuffers(((UndertowSettings)this.getSettings()).getDirectBuffers());
        }
        if (((UndertowSettings)this.getSettings()).getIoThreads() > 0) {
            builder.setIoThreads(((UndertowSettings)this.getSettings()).getIoThreads());
        }
        if (((UndertowSettings)this.getSettings()).getWorkerThreads() > 0) {
            builder.setWorkerThreads(((UndertowSettings)this.getSettings()).getWorkerThreads());
        }
        if (((UndertowSettings)this.getSettings()).getKeystoreFile() == null) {
            builder.addHttpListener(((UndertowSettings)this.getSettings()).getPort(), ((UndertowSettings)this.getSettings()).getHost());
        } else {
            builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true);
            try {
                KeyStore keyStore = this.loadKeyStore(((UndertowSettings)this.getSettings()).getKeystoreFile(), ((UndertowSettings)this.getSettings()).getKeystorePassword());
                KeyStore trustStore = this.loadKeyStore(((UndertowSettings)this.getSettings()).getTruststoreFile(), ((UndertowSettings)this.getSettings()).getTruststorePassword());
                SSLContext sslContext = this.createSSLContext(keyStore, trustStore);
                builder.addHttpsListener(((UndertowSettings)this.getSettings()).getPort(), ((UndertowSettings)this.getSettings()).getHost(), sslContext);
            }
            catch (Exception e) {
                throw new PippoRuntimeException((Throwable)e, "Failed to setup an Undertow SSL listener!", new Object[0]);
            }
        }
        ((UndertowSettings)this.getSettings()).addUndertowOptions(builder);
        builder.setHandler(contextHandler);
        return builder.build();
    }

    protected HttpHandler createContextHandler(HttpHandler pippoHandler) throws ServletException {
        String contextPath = ((UndertowSettings)this.getSettings()).getContextPath();
        PathHandler contextHandler = Handlers.path((HttpHandler)Handlers.redirect((String)contextPath));
        contextHandler.addPrefixPath(contextPath, pippoHandler);
        return contextHandler;
    }

    protected PippoFilter createPippoFilter() {
        return new UndertowWebSocketFilter();
    }

    protected DeploymentManager createPippoDeploymentManager() throws ServletException {
        DeploymentInfo info = Servlets.deployment();
        info.setDeploymentName("Pippo");
        info.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        info.setContextPath(((UndertowSettings)this.getSettings()).getContextPath());
        info.setIgnoreFlush(true);
        info.addServletContextAttribute("PIPPO_APPLICATION", (Object)this.getApplication());
        this.addPippoFilter(info);
        info.addListener(new ListenerInfo(PippoServletContextListener.class));
        this.listeners.forEach(listener -> info.addListener(new ListenerInfo(listener)));
        ServletInfo defaultServlet = new ServletInfo("DefaultServlet", DefaultServlet.class);
        defaultServlet.addMapping("/");
        MultipartConfigElement multipartConfig = this.createMultipartConfigElement();
        defaultServlet.setMultipartConfig(multipartConfig);
        info.addServlets(new ServletInfo[]{defaultServlet});
        DeploymentManager deploymentManager = Servlets.defaultContainer().addDeployment(info);
        deploymentManager.deploy();
        return deploymentManager;
    }

    private MultipartConfigElement createMultipartConfigElement() {
        Application application = this.getApplication();
        String location = application.getUploadLocation();
        long maxFileSize = application.getMaximumUploadSize();
        return new MultipartConfigElement(location, maxFileSize, -1L, 0);
    }

    private void addPippoFilter(DeploymentInfo info) {
        if (this.pippoFilterPath == null) {
            this.pippoFilterPath = "/*";
        }
        info.addFilter(new FilterInfo("PippoFilter", PippoFilter.class, (InstanceFactory)new ImmediateInstanceFactory((Object)this.getPippoFilter())));
        info.addFilterUrlMapping("PippoFilter", this.pippoFilterPath, DispatcherType.REQUEST);
        log.debug("Using pippo filter for path '{}'", (Object)this.pippoFilterPath);
    }

    private SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, ((UndertowSettings)this.getSettings()).getKeystorePassword().toCharArray());
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private KeyStore loadKeyStore(String filename, String password) throws Exception {
        KeyStore loadedKeystore = KeyStore.getInstance("JKS");
        File file = new File(filename);
        if (file.exists()) {
            try (FileInputStream stream = new FileInputStream(file);){
                loadedKeystore.load(stream, password.toCharArray());
            }
        } else {
            log.error("Failed to find keystore '{}'!", (Object)filename);
        }
        return loadedKeystore;
    }
}

