/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Option;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.WebServerSettings;
import ro.pippo.undertow.UndertowServer;

public class UndertowSettings
extends WebServerSettings {
    private static final Logger log = LoggerFactory.getLogger(UndertowServer.class);
    public static final String BUFFER_SIZE = "undertow.bufferSize";
    private static final String PREFIX = "undertow.";
    private static final String UNDERTOW_SERVER_PREFIX = "undertow.server.";
    private static final String UNDERTOW_WORKER_PREFIX = "undertow.worker.";
    private static final String UNDERTOW_SOCKET_PREFIX = "undertow.socket.";
    public static final String BUFFERS_PER_REGION = "undertow.buffersPerRegion";
    public static final String DIRECT_BUFFERS = "undertow.directBuffers";
    public static final String IO_THREADS = "undertow.ioThreads";
    public static final String WORKER_THREADS = "undertow.workerThreads";
    private int bufferSize;
    private int buffersPerRegion;
    private int ioThreads;
    private int workerThreads;
    private Boolean directBuffers;
    private PippoSettings pippoSettings;

    public UndertowSettings(PippoSettings pippoSettings) {
        super(pippoSettings);
        this.bufferSize = pippoSettings.getInteger(BUFFER_SIZE, 0);
        this.buffersPerRegion = pippoSettings.getInteger(BUFFERS_PER_REGION, 0);
        this.directBuffers = pippoSettings.getBoolean(DIRECT_BUFFERS, false);
        this.ioThreads = pippoSettings.getInteger(IO_THREADS, 0);
        this.workerThreads = pippoSettings.getInteger(WORKER_THREADS, 0);
        this.pippoSettings = pippoSettings;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getBuffersPerRegion() {
        return this.buffersPerRegion;
    }

    public boolean getDirectBuffers() {
        return this.directBuffers;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public UndertowSettings setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public UndertowSettings setBuffersPerRegion(int buffersPerRegion) {
        this.buffersPerRegion = buffersPerRegion;
        return this;
    }

    public UndertowSettings setDirectBuffers(boolean directBuffers) {
        this.directBuffers = directBuffers;
        return this;
    }

    public UndertowSettings setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
        return this;
    }

    public UndertowSettings setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    public void addUndertowOptions(Undertow.Builder builder) {
        List propertyNames = this.pippoSettings.getSettingNames(PREFIX);
        for (String propertyName : propertyNames) {
            String typeName = null;
            String prefix = null;
            if (propertyName.startsWith(UNDERTOW_SERVER_PREFIX)) {
                prefix = UNDERTOW_SERVER_PREFIX;
            } else if (propertyName.startsWith(UNDERTOW_SOCKET_PREFIX)) {
                prefix = UNDERTOW_SOCKET_PREFIX;
            } else if (propertyName.startsWith(UNDERTOW_WORKER_PREFIX)) {
                prefix = UNDERTOW_WORKER_PREFIX;
            }
            if (prefix != null) {
                typeName = this.getTypeName(propertyName.replace(prefix, ""));
            }
            if (typeName == null) continue;
            this.addUndertowOption(builder, propertyName, prefix, typeName);
        }
    }

    private String getTypeName(String parameter) {
        try {
            Field field = UndertowOptions.class.getDeclaredField(parameter);
            if (Option.class.getName().equals(field.getType().getTypeName())) {
                Object value = field.get(null);
                Field optionField = value.getClass().getDeclaredField("type");
                optionField.setAccessible(true);
                return optionField.get(value).toString();
            }
        }
        catch (Exception e) {
            log.debug("getting Option type for parameter {} failed with {}", (Object)parameter, (Object)e);
        }
        return null;
    }

    private void addUndertowOption(Undertow.Builder builder, String propertyName, String prefix, String typeName) {
        if (typeName.equals(Integer.class.toString())) {
            int value = this.pippoSettings.getInteger(propertyName, Integer.MIN_VALUE);
            if (value > Integer.MIN_VALUE) {
                Option option = Option.simple(UndertowOptions.class, (String)propertyName.replace(prefix, ""), Integer.class);
                this.addUndertowOption(builder, option, value, prefix);
            }
        } else if (typeName.equals(Long.class.toString())) {
            long value = this.pippoSettings.getLong(propertyName, Long.MIN_VALUE);
            if (value > Long.MIN_VALUE) {
                Option option = Option.simple(UndertowOptions.class, (String)propertyName.replace(prefix, ""), Long.class);
                this.addUndertowOption(builder, option, value, prefix);
            }
        } else if (typeName.equals(String.class.toString())) {
            Option option = Option.simple(UndertowOptions.class, (String)propertyName.replace(prefix, ""), String.class);
            this.addUndertowOption(builder, option, this.pippoSettings.getString(propertyName, ""), prefix);
        } else if (typeName.equals(Boolean.class.toString())) {
            Option option = Option.simple(UndertowOptions.class, (String)propertyName.replace(prefix, ""), Boolean.class);
            this.addUndertowOption(builder, option, this.pippoSettings.getBoolean(propertyName, false), prefix);
        }
    }

    private <T> void addUndertowOption(Undertow.Builder builder, Option<T> option, T value, String prefix) {
        switch (prefix) {
            case "undertow.server.": {
                builder.setServerOption(option, value);
                break;
            }
            case "undertow.socket.": {
                builder.setSocketOption(option, value);
                break;
            }
            case "undertow.worker.": {
                builder.setWorkerOption(option, value);
                break;
            }
        }
    }
}

