/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.undertow.websocket;

import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;
import org.xnio.Pooled;
import ro.pippo.core.websocket.WebSocketConnection;
import ro.pippo.core.websocket.WebSocketContext;
import ro.pippo.core.websocket.WebSocketHandler;
import ro.pippo.undertow.websocket.UndertowWebSocketConnection;

public class UndertowWebSocketAdapter
extends AbstractReceiveListener
implements WebSocketConnectionCallback {
    private static final Logger log = LoggerFactory.getLogger(UndertowWebSocketAdapter.class);
    private static List<WebSocketConnection> connections = new CopyOnWriteArrayList<WebSocketConnection>();
    private final WebSocketHandler handler;
    private final Map<String, String> pathParameters;
    private WebSocketContext context;
    private WebSocketConnection connection;

    public UndertowWebSocketAdapter(WebSocketHandler handler, Map<String, String> pathParameters) {
        this.handler = handler;
        this.pathParameters = pathParameters;
    }

    public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        channel.getReceiveSetter().set((ChannelListener)this);
        channel.resumeReceives();
        this.connection = new UndertowWebSocketConnection(exchange, channel);
        connections.add(this.connection);
        this.context = new WebSocketContext(connections, this.connection, this.pathParameters);
        this.handler.onOpen(this.context);
    }

    protected void onCloseMessage(CloseMessage cm, WebSocketChannel channel) {
        this.handler.onClose(this.context, cm.getCode(), cm.getReason());
        connections.remove(this.connection);
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        super.onError(channel, error);
        if (error instanceof SocketTimeoutException) {
            this.handler.onTimeout(this.context);
        } else {
            log.error("An error occurred when using WebSocket", error);
            this.handler.onError(this.context, error);
        }
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
        this.handler.onMessage(this.context, message.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        Pooled pulledData = message.getData();
        try {
            ByteBuffer[] resource = (ByteBuffer[])pulledData.getResource();
            ByteBuffer buffer = WebSockets.mergeBuffers((ByteBuffer[])resource);
            this.handler.onMessage(this.context, buffer.array());
        }
        finally {
            pulledData.discard();
        }
    }
}

