/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.undertow.websocket;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.websocket.WebSocketConnection;

public class UndertowWebSocketConnection
implements WebSocketConnection {
    private final WebSocketHttpExchange exchange;
    private final WebSocketChannel channel;

    public UndertowWebSocketConnection(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        this.exchange = exchange;
        this.channel = channel;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close(int code, String reason) {
        this.channel.setCloseCode(code);
        this.channel.setCloseReason(reason);
        try {
            this.channel.sendClose();
        }
        catch (IOException e) {
            throw new PippoRuntimeException((Throwable)e);
        }
    }

    public WebSocketConnection sendMessage(String message) throws IOException {
        this.checkClosed();
        WebSockets.sendText((String)message, (WebSocketChannel)this.channel, null);
        return this;
    }

    public WebSocketConnection sendMessage(byte[] message) throws IOException {
        this.checkClosed();
        ByteBuffer buffer = ByteBuffer.wrap(message, 0, message.length);
        WebSockets.sendBinary((ByteBuffer)buffer, (WebSocketChannel)this.channel, null);
        return this;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.channel.getSourceAddress();
    }

    public WebSocketHttpExchange getExchange() {
        return this.exchange;
    }

    public WebSocketChannel getChannel() {
        return this.channel;
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is closed");
        }
    }
}

