/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.undertow.websocket;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xnio.StreamConnection;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.Request;
import ro.pippo.core.Response;
import ro.pippo.core.websocket.AbstractWebSocketFilter;
import ro.pippo.core.websocket.WebSocketRouter;
import ro.pippo.undertow.websocket.UndertowWebSocketAdapter;

public class UndertowWebSocketFilter
extends AbstractWebSocketFilter {
    private Set<WebSocketChannel> peerConnections;
    private Set<Handshake> handshakes;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.peerConnections = Collections.newSetFromMap(new ConcurrentHashMap());
        this.handshakes = new HashSet<Handshake>();
        this.handshakes.add((Handshake)new Hybi13Handshake());
        this.handshakes.add((Handshake)new Hybi08Handshake());
        this.handshakes.add((Handshake)new Hybi07Handshake());
    }

    protected void processRequest(Request request, Response response) throws IOException, ServletException {
        if (!this.acceptWebSocket(request, response)) {
            super.processRequest(request, response);
        } else {
            this.processWebSocketRequest(request, response);
        }
    }

    private void processWebSocketRequest(Request request, Response response) {
        HttpServletRequest servletRequest = request.getHttpServletRequest();
        HttpServletResponse servletResponse = response.getHttpServletResponse();
        ServletWebSocketHttpExchange exchange = new ServletWebSocketHttpExchange(servletRequest, servletResponse, this.peerConnections);
        Handshake handshake = this.getHandshake((WebSocketHttpExchange)exchange);
        exchange.upgradeChannel((arg_0, arg_1) -> this.lambda$processWebSocketRequest$0(handshake, (WebSocketHttpExchange)exchange, request, arg_0, arg_1));
        handshake.handshake((WebSocketHttpExchange)exchange);
    }

    private Handshake getHandshake(WebSocketHttpExchange exchange) {
        for (Handshake handshake : this.handshakes) {
            if (!handshake.matches(exchange)) continue;
            return handshake;
        }
        throw new PippoRuntimeException("No matching Undertow Handshake found: {}", new Object[]{exchange.getRequestHeaders()});
    }

    protected UndertowWebSocketAdapter createWebSocketAdapter(Request request) {
        WebSocketRouter.WebSocketMatch match = this.findWebSocketRoute(request.getUri());
        return new UndertowWebSocketAdapter(match.getHandler(), match.getPathParameters());
    }

    private /* synthetic */ void lambda$processWebSocketRequest$0(Handshake handshake, WebSocketHttpExchange exchange, Request request, StreamConnection connection, HttpServerExchange serverExchange) {
        WebSocketChannel channel = handshake.createChannel(exchange, connection, exchange.getBufferPool());
        this.peerConnections.add(channel);
        this.createWebSocketAdapter(request).onConnect(exchange, channel);
    }
}

