/*
 * Decompiled with CFR 0.152.
 */
package ru.homyakin.iuliia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Schema {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    private Map<String, String> mapping;
    private Map<String, String> prevMapping;
    private Map<String, String> nextMapping;
    private Map<String, String> endingMapping;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<String> translateEnding(String ending) {
        if (ending.equals("")) {
            return Optional.of(ending);
        }
        return Optional.ofNullable(this.endingMapping.getOrDefault(ending, null));
    }

    public String translateLetter(String prev, String curr, String next) {
        String letter = this.prevMapping.get(prev + curr);
        if (letter == null) {
            letter = this.nextMapping.get(curr + next);
        }
        if (letter == null) {
            letter = this.mapping.getOrDefault(curr, curr);
        }
        return letter;
    }

    @JsonProperty(value="mapping")
    private void unpackMapping(Map<String, String> mapping) {
        this.mapping = this.createMapping(mapping);
    }

    @JsonProperty(value="prev_mapping")
    private void unpackPrevMapping(Map<String, String> prevMapping) {
        this.prevMapping = this.createMapping(prevMapping);
    }

    @JsonProperty(value="next_mapping")
    private void unpackNextMapping(Map<String, String> nextMapping) {
        this.nextMapping = this.createMapping(nextMapping);
    }

    @JsonProperty(value="ending_mapping")
    private void unpackEndingMapping(Map<String, String> endingMapping) {
        this.endingMapping = this.createMapping(endingMapping);
    }

    private Map<String, String> createMapping(Map<String, String> mapping) {
        if (mapping == null) {
            return new HashMap<String, String>();
        }
        HashSet<Map.Entry<String, String>> entrySet = new HashSet<Map.Entry<String, String>>(mapping.entrySet());
        for (Map.Entry<String, String> entry : entrySet) {
            mapping.put(this.capitalize(entry.getKey()), this.capitalize(entry.getValue()));
        }
        return mapping;
    }

    private String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }
}

