/*
 * Decompiled with CFR 0.152.
 */
package ru.homyakin.iuliia;

import java.io.IOException;
import java.util.Optional;
import javafx.util.Pair;
import ru.homyakin.iuliia.Schema;
import ru.homyakin.iuliia.Schemas;

public class Translator {
    private final Schema schema;

    public Translator(Schemas schema) throws IOException {
        this.schema = schema.getSchema();
    }

    public String translate(String str) {
        if (str == null) {
            return null;
        }
        String[] words = str.split(" ");
        StringBuilder translated = new StringBuilder();
        for (String word : words) {
            translated.append(this.translateWord(word));
        }
        return translated.toString();
    }

    private String translateWord(String word) {
        Pair<String, String> pair = this.splitWord(word);
        Optional<String> translatedEnding = this.schema.translateEnding((String)pair.getValue());
        return this.translateLetters((String)pair.getKey()) + translatedEnding.orElseGet(() -> this.translateLetters((String)pair.getValue()));
    }

    private String translateLetters(String word) {
        String prev = "";
        String curr = "";
        String next = "";
        int length = word.length();
        StringBuilder translated = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (!curr.equals("")) {
                prev = curr;
            }
            curr = next.equals("") ? String.valueOf(word.charAt(i)) : next;
            if (i < length - 1) {
                next = String.valueOf(word.charAt(i + 1));
            }
            translated.append(this.schema.translateLetter(prev, curr, next));
        }
        return translated.toString();
    }

    private Pair<String, String> splitWord(String word) {
        int endingLength = 2;
        if (word.length() > endingLength) {
            int separateIndex = word.length() - endingLength;
            return new Pair((Object)word.substring(0, separateIndex), (Object)word.substring(separateIndex));
        }
        return new Pair((Object)word, (Object)"");
    }
}

