/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign;

import java.security.Provider;
import java.security.Security;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.i_novus.common.sign.SignatureGost;

public final class Init {
    private static final Logger logger = LoggerFactory.getLogger(Init.class);
    private static boolean initialized = false;

    private Init() {
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        org.apache.xml.security.Init.init();
        Security.removeProvider("ApacheXMLDSig");
        Security.addProvider(new XMLDSigRI());
        Security.addProvider((Provider)new BouncyCastleProvider());
        JCEMapper.Algorithm digest = new JCEMapper.Algorithm("", "GOST3411", "MessageDigest");
        JCEMapper.register("http://www.w3.org/2001/04/xmldsig-more#gostr3411", digest);
        JCEMapper.register("urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr3411", digest);
        JCEMapper.Algorithm signature = new JCEMapper.Algorithm("", "GOST3411withECGOST3410", "Signature");
        JCEMapper.register("http://www.w3.org/2001/04/xmldsig-more#gostr34102001-gostr3411", signature);
        JCEMapper.register("urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102001-gostr3411", signature);
        digest = new JCEMapper.Algorithm("", "GOST3411-2012-256", "MessageDigest");
        JCEMapper.register("http://www.w3.org/2001/04/xmldsig-more#gostr34112012-256", digest);
        JCEMapper.register("urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34112012-256", digest);
        signature = new JCEMapper.Algorithm("", "GOST3411-2012-256withECGOST3410-2012-256", "Signature");
        JCEMapper.register("http://www.w3.org/2001/04/xmldsig-more#gostr34102012-gostr34112012-256", signature);
        JCEMapper.register("urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102012-gostr34112012-256", signature);
        digest = new JCEMapper.Algorithm("", "GOST3411-2012-512", "MessageDigest");
        JCEMapper.register("http://www.w3.org/2001/04/xmldsig-more#gostr34112012-512", digest);
        JCEMapper.register("urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34112012-512", digest);
        signature = new JCEMapper.Algorithm("", "GOST3411-2012-512withECGOST3410-2012-512", "Signature");
        JCEMapper.register("http://www.w3.org/2001/04/xmldsig-more#gostr34102012-gostr34112012-512", signature);
        JCEMapper.register("urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102012-gostr34112012-512", signature);
        Init.registerSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#gostr34102001-gostr3411", SignatureGost.Gost3410_2001_Uri.class);
        Init.registerSignatureAlgorithm("urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102001-gostr3411", SignatureGost.Gost3410_2001_Urn.class);
        Init.registerSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#gostr34102012-gostr34112012-256", SignatureGost.Gost3410_2012_256_Uri.class);
        Init.registerSignatureAlgorithm("urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102012-gostr34112012-256", SignatureGost.Gost3410_2012_256_Urn.class);
        Init.registerSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#gostr34102012-gostr34112012-512", SignatureGost.Gost3410_2012_512_Uri.class);
        Init.registerSignatureAlgorithm("urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102012-gostr34112012-512", SignatureGost.Gost3410_2012_512_Urn.class);
        initialized = true;
    }

    private static void registerSignatureAlgorithm(String algorithmURI, Class<? extends SignatureAlgorithmSpi> implementation) {
        try {
            SignatureAlgorithm.register(algorithmURI, implementation);
        }
        catch (ClassNotFoundException | AlgorithmAlreadyRegisteredException | XMLSignatureException e) {
            logger.info("Cannot register algorithm '{}'", (Object)algorithmURI, (Object)e);
        }
    }
}

