/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.digests.GOST3411_2012_256Digest;
import org.bouncycastle.crypto.digests.GOST3411_2012_512Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ecgost12.BCECGOST3410_2012PrivateKey;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcECContentSignerBuilder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.i_novus.common.sign.api.SignAlgorithmType;
import ru.i_novus.common.sign.util.Base64Util;
import ru.i_novus.common.sign.util.CryptoFormatConverter;

public class CryptoUtil {
    private static final Logger logger = LoggerFactory.getLogger(CryptoUtil.class);
    static final String CRYPTO_PROVIDER_NAME = "BC";
    private static final int BUFFER_SIZE = 1024;

    private CryptoUtil() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static KeyPair generateKeyPair(SignAlgorithmType signAlgorithmType, String parameterSpecName) throws NoSuchProviderException, NoSuchAlgorithmException {
        logger.info("Generating keypair, signAlgorithm: {}, parameterSpecName: {}", (Object)signAlgorithmType, (Object)parameterSpecName);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(signAlgorithmType.getBouncyKeyAlgorithmName(), CRYPTO_PROVIDER_NAME);
        String selectedParamSpec = CryptoUtil.getParamSpec(signAlgorithmType, parameterSpecName);
        logger.info("selected parameter specification name: {}", (Object)selectedParamSpec);
        if (selectedParamSpec != null) {
            try {
                keyGen.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec(selectedParamSpec), new SecureRandom());
            }
            catch (InvalidAlgorithmParameterException e) {
                logger.error("Cannot initialize KeyGen with param '{}'", (Object)selectedParamSpec, (Object)e);
                throw new IllegalStateException("Cannot initialize KeyGen", e);
            }
        }
        return keyGen.generateKeyPair();
    }

    private static String getParamSpec(SignAlgorithmType signAlgorithmType, String parameterSpecName) {
        String selectedParamSpec = null;
        if (parameterSpecName == null) {
            if (!signAlgorithmType.getAvailableParameterSpecificationNames().isEmpty()) {
                selectedParamSpec = (String)signAlgorithmType.getAvailableParameterSpecificationNames().get(0);
            }
        } else {
            if (!signAlgorithmType.getAvailableParameterSpecificationNames().contains(parameterSpecName)) {
                throw new IllegalArgumentException(MessageFormat.format("Parameter specification name {0} is not supported for algorithm {1}. Supported values: {2}", parameterSpecName, signAlgorithmType.name(), signAlgorithmType.getAvailableParameterSpecificationNames()));
            }
            selectedParamSpec = parameterSpecName;
        }
        return selectedParamSpec;
    }

    public static X509CertificateHolder selfSignedCertificate(String x509Name, KeyPair keyPair, SignAlgorithmType signAlgorithm, Date validFrom, Date validTo) {
        Object k;
        X500Name name = new X500Name(x509Name);
        RSAKeyParameters privateKeyParameter = null;
        RSAKeyParameters publicKeyParameter = null;
        BigInteger serial = BigInteger.ONE;
        Date notBefore = validFrom == null ? new Date() : validFrom;
        Date notAfter = validTo == null ? new Date(LocalDateTime.now().plusYears(1L).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()) : validTo;
        X509v3CertificateBuilder certificateBuilder = null;
        if (keyPair.getPublic() instanceof ECPublicKey) {
            k = (ECPublicKey)keyPair.getPublic();
            ECParameterSpec s = k.getParameters();
            publicKeyParameter = new ECPublicKeyParameters(k.getQ(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN()));
            ECPrivateKey kk = (ECPrivateKey)keyPair.getPrivate();
            ECParameterSpec ss = kk.getParameters();
            privateKeyParameter = new ECPrivateKeyParameters(kk.getD(), new ECDomainParameters(ss.getCurve(), ss.getG(), ss.getN()));
            certificateBuilder = new JcaX509v3CertificateBuilder(name, serial, notBefore, notAfter, name, keyPair.getPublic());
        } else if (keyPair.getPublic() instanceof RSAPublicKey) {
            k = (RSAPublicKey)keyPair.getPublic();
            publicKeyParameter = new RSAKeyParameters(false, k.getModulus(), k.getPublicExponent());
            RSAPrivateKey kk = (RSAPrivateKey)keyPair.getPrivate();
            privateKeyParameter = new RSAKeyParameters(true, kk.getModulus(), kk.getPrivateExponent());
            try {
                certificateBuilder = new X509v3CertificateBuilder(name, serial, notBefore, notAfter, name, SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)publicKeyParameter));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot create SubjectPublicKeyInfo", e);
            }
        }
        if (publicKeyParameter == null) {
            return null;
        }
        DefaultSignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder = new DefaultSignatureAlgorithmIdentifierFinder();
        DefaultDigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder = new DefaultDigestAlgorithmIdentifierFinder();
        AlgorithmIdentifier signAlgId = signatureAlgorithmIdentifierFinder.find(signAlgorithm.getSignatureAlgorithmName());
        AlgorithmIdentifier digestAlgId = digestAlgorithmIdentifierFinder.find(signAlgId);
        Object signerBuilder = keyPair.getPublic() instanceof ECPublicKey ? new BcECContentSignerBuilder(signAlgId, digestAlgId) : new BcRSAContentSignerBuilder(signAlgId, digestAlgId);
        int val = 2;
        val |= 0x10;
        val |= 0x8000;
        val |= 0x80;
        val |= 1;
        val |= 8;
        val |= 0x20;
        CryptoUtil.addCertificateExtension(certificateBuilder, Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(val |= 0x40));
        CryptoUtil.addCertificateExtension(certificateBuilder, Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        CryptoUtil.addCertificateExtension(certificateBuilder, Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_timeStamping));
        try {
            return certificateBuilder.build(signerBuilder.build((AsymmetricKeyParameter)privateKeyParameter));
        }
        catch (OperatorCreationException e) {
            throw new IllegalStateException("Signer could not been created for the key", e);
        }
    }

    private static void addCertificateExtension(X509v3CertificateBuilder certificateBuilder, ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) {
        try {
            certificateBuilder.addExtension(oid, isCritical, value);
        }
        catch (CertIOException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static String getBase64Digest(String data, SignAlgorithmType signAlgorithmType) {
        return Base64Util.getBase64EncodedString(CryptoUtil.getDigest(data.getBytes(), signAlgorithmType));
    }

    public static byte[] getDigest(byte[] data, SignAlgorithmType signAlgorithmType) {
        ExtendedDigest digest = CryptoUtil.fillDigest(signAlgorithmType);
        digest.update(data, 0, data.length);
        byte[] resBuf = new byte[digest.getDigestSize()];
        digest.doFinal(resBuf, 0);
        return resBuf;
    }

    public static byte[] getFileDigest(byte[] fileBytes, SignAlgorithmType signAlgorithmType) {
        MessageDigest digest;
        ExtendedDigest extendedDigest = CryptoUtil.fillDigest(signAlgorithmType);
        String algorithmName = extendedDigest.getAlgorithmName();
        try {
            digest = MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Cryptoprovider does not support algorithm '" + algorithmName + "'", ex);
        }
        digest.update(fileBytes);
        return digest.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getDigest(InputStream inputStream, SignAlgorithmType signAlgorithmType) throws IOException {
        ExtendedDigest digest = CryptoUtil.fillDigest(signAlgorithmType);
        try {
            int numRead;
            byte[] dataBytes = new byte[1024];
            while ((numRead = inputStream.read(dataBytes)) != -1) {
                digest.update(dataBytes, 0, numRead);
            }
            byte[] resBuf = new byte[digest.getDigestSize()];
            digest.doFinal(resBuf, 0);
            byte[] byArray = resBuf;
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public static byte[] getCMSSignature(byte[] data, PrivateKey privateKey, X509Certificate certificate) throws GeneralSecurityException, IOException, CMSException, OperatorCreationException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
        certList.add(certificate);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner signer = new JcaContentSignerBuilder(CryptoUtil.getSignatureAlgorithmName(certificate, privateKey)).setProvider(CRYPTO_PROVIDER_NAME).build(privateKey);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(CRYPTO_PROVIDER_NAME).build()).build(signer, certificate));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, false);
        return sigData.getEncoded();
    }

    private static String getSignatureAlgorithmName(X509Certificate certificate, PrivateKey privateKey) {
        if (privateKey instanceof BCECGOST3410_2012PrivateKey && ((BCECGOST3410_2012PrivateKey)privateKey).getParams().getOrder().bitLength() == 512) {
            return SignAlgorithmType.ECGOST3410_2012_512.getSignatureAlgorithmName();
        }
        return certificate.getSigAlgName();
    }

    public static byte[] getSignature(byte[] data, PrivateKey privateKey, SignAlgorithmType signAlgorithmType) throws GeneralSecurityException {
        Signature signature = CryptoUtil.getSignatureInstance(signAlgorithmType);
        signature.initSign(privateKey);
        signature.update(data);
        return signature.sign();
    }

    public static String getBase64Signature(String data, String key, SignAlgorithmType signAlgorithmType) throws GeneralSecurityException {
        PrivateKey privateKey = CryptoFormatConverter.getInstance().getPKFromPEMEncoded(signAlgorithmType, key);
        byte[] signBytes = CryptoUtil.getSignature(data.getBytes(), privateKey, signAlgorithmType);
        return Base64Util.getBase64EncodedString(signBytes);
    }

    public static String getThumbPrint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return CryptoUtil.hexify(digest);
    }

    private static String hexify(byte[] data) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(data.length * 2);
        for (byte aByte : data) {
            buf.append(hexDigits[(aByte & 0xF0) >> 4]);
            buf.append(hexDigits[aByte & 0xF]);
        }
        return buf.toString();
    }

    private static ExtendedDigest fillDigest(SignAlgorithmType signAlgorithmType) {
        switch (signAlgorithmType) {
            case ECGOST3410: {
                return new GOST3411Digest();
            }
            case ECGOST3410_2012_256: {
                return new GOST3411_2012_256Digest();
            }
            case ECGOST3410_2012_512: {
                return new GOST3411_2012_512Digest();
            }
        }
        throw new IllegalArgumentException("Unsupported Digest Algorithm: " + signAlgorithmType);
    }

    public static Signature getSignatureInstance(SignAlgorithmType signAlgorithmType) throws GeneralSecurityException {
        String algorithmName = signAlgorithmType.getSignatureAlgorithmName();
        return Signature.getInstance(algorithmName, CRYPTO_PROVIDER_NAME);
    }
}

