/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign.util;

import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtil {
    private static final Logger logger = LoggerFactory.getLogger(DomUtil.class);

    private DomUtil() {
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        return dbf.newDocumentBuilder().newDocument();
    }

    public static Node getNodeFirstChild(Node node) {
        NodeList nodes = node.getChildNodes();
        Node rootNode = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            rootNode = nodes.item(i);
            break;
        }
        return rootNode;
    }

    public static String elementToString(Element element, Charset xmlEncoding) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer tf = factory.newTransformer();
        tf.setOutputProperty("omit-xml-declaration", "no");
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("encoding", xmlEncoding.name());
        StringWriter writer = new StringWriter();
        tf.transform(new DOMSource(element), new StreamResult(writer));
        return writer.toString();
    }
}

