/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import javax.activation.DataHandler;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.i_novus.common.sign.api.SignAlgorithmType;
import ru.i_novus.common.sign.util.CryptoFormatConverter;
import ru.i_novus.common.sign.util.CryptoUtil;

public class FileSignatureVerifier {
    private static final Logger logger = LoggerFactory.getLogger(FileSignatureVerifier.class);
    private static final int BUFFER_SIZE = 4096;

    private FileSignatureVerifier() {
    }

    public static boolean verifyDigest(DataHandler dataHandler, byte[] signedDataByteArray) throws CMSException {
        byte[] data;
        try {
            data = Streams.readAll((InputStream)dataHandler.getInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read data from DataHandler", e);
        }
        CMSSignedData signedData = new CMSSignedData(signedDataByteArray);
        X509Certificate x509Certificate = FileSignatureVerifier.getX509Certificate(signedData).orElseThrow(() -> new IllegalStateException("Certificate was not received from signed data"));
        SignerInformation signerInformation = FileSignatureVerifier.getSignerInformation(signedData).orElseThrow(() -> new IllegalStateException("Signature metadata was not received from signed data"));
        SignAlgorithmType signAlgorithmType = SignAlgorithmType.findByCertificate((X509Certificate)x509Certificate);
        byte[] argDigestedData = CryptoUtil.getFileDigest(data, signAlgorithmType);
        ASN1ObjectIdentifier asn1ObjectIdentifier = PKCSObjectIdentifiers.pkcs_9_at_messageDigest;
        Attribute attribute = signerInformation.getSignedAttributes().get(asn1ObjectIdentifier);
        DEROctetString oct = (DEROctetString)attribute.getAttributeValues()[0];
        byte[] signedDigestedData = oct.getOctets();
        return Arrays.equals(argDigestedData, signedDigestedData);
    }

    public static boolean verifyPKCS7Signature(byte[] signedDataByteArray) throws CMSException, GeneralSecurityException, IOException {
        boolean signatureIsVerified;
        CMSSignedData signedData = new CMSSignedData(signedDataByteArray);
        X509Certificate x509Certificate = FileSignatureVerifier.getX509Certificate(signedData).orElseThrow(() -> new IllegalStateException("Certificate was not received from signed data"));
        SignerInformation signerInformation = FileSignatureVerifier.getSignerInformation(signedData).orElseThrow(() -> new IllegalStateException("Signature metadata was not received from signed data"));
        byte[] signatureAsByteArray = signerInformation.getSignature();
        SignAlgorithmType signAlgorithmType = SignAlgorithmType.findByCertificate((X509Certificate)x509Certificate);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(signerInformation.getEncodedSignedAttributes());){
            int readBytesCount;
            Signature signature = CryptoUtil.getSignatureInstance(signAlgorithmType);
            signature.initVerify(x509Certificate);
            byte[] localBuffer = new byte[4096];
            while ((readBytesCount = inputStream.read(localBuffer)) > 0) {
                signature.update(localBuffer, 0, readBytesCount);
            }
            signatureIsVerified = signature.verify(signatureAsByteArray);
        }
        return signatureIsVerified;
    }

    private static Optional<SignerInformation> getSignerInformation(CMSSignedData signedData) {
        SignerInformationStore signerInformationStore = signedData.getSignerInfos();
        return signerInformationStore.getSigners().stream().findFirst();
    }

    private static Optional<X509Certificate> getX509Certificate(CMSSignedData signedData) {
        Optional x509CertificateHolder = signedData.getCertificates().getMatches(null).stream().findFirst();
        return x509CertificateHolder.map(certificateHolder -> CryptoFormatConverter.getInstance().getCertificateFromHolder((X509CertificateHolder)certificateHolder));
    }
}

