/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;

public abstract class SignatureGost
extends SignatureAlgorithmSpi {
    private Signature signatureAlgorithm;

    private SignatureGost() throws XMLSignatureException {
        String algorithmID = JCEMapper.translateURItoJCEID(this.engineGetURI());
        String provider = JCEMapper.getProviderId();
        try {
            this.signatureAlgorithm = provider == null ? Signature.getInstance(algorithmID) : Signature.getInstance(algorithmID, provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            Object[] exArgs = new Object[]{algorithmID, e.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs);
        }
    }

    @Override
    protected abstract String engineGetURI();

    @Override
    protected String engineGetJCEAlgorithmString() {
        return this.signatureAlgorithm.getAlgorithm();
    }

    @Override
    protected String engineGetJCEProviderName() {
        return this.signatureAlgorithm.getProvider().getName();
    }

    @Override
    protected void engineUpdate(byte[] input) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(input);
        }
        catch (SignatureException e) {
            throw new XMLSignatureException(e.toString());
        }
    }

    @Override
    protected void engineUpdate(byte input) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(input);
        }
        catch (SignatureException e) {
            throw new XMLSignatureException(e.toString());
        }
    }

    @Override
    protected void engineUpdate(byte[] buf, int offset, int len) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(buf, offset, len);
        }
        catch (SignatureException e) {
            throw new XMLSignatureException(e.toString());
        }
    }

    @Override
    protected void engineInitSign(Key signingKey) throws XMLSignatureException {
        this.engineInitSign(signingKey, (SecureRandom)null);
    }

    @Override
    protected void engineInitSign(Key signingKey, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(signingKey instanceof PrivateKey)) {
            String supplied = null;
            if (signingKey != null) {
                supplied = signingKey.getClass().getName();
            }
            String needed = PrivateKey.class.getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            if (secureRandom == null) {
                this.signatureAlgorithm.initSign((PrivateKey)signingKey);
            } else {
                this.signatureAlgorithm.initSign((PrivateKey)signingKey, secureRandom);
            }
        }
        catch (InvalidKeyException e) {
            throw new XMLSignatureException(e.toString());
        }
    }

    @Override
    protected void engineInitSign(Key signingKey, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnDSA");
    }

    @Override
    protected byte[] engineSign() throws XMLSignatureException {
        try {
            return this.signatureAlgorithm.sign();
        }
        catch (SignatureException e) {
            throw new XMLSignatureException(e.toString());
        }
    }

    @Override
    protected void engineInitVerify(Key verificationKey) throws XMLSignatureException {
        if (!(verificationKey instanceof PublicKey)) {
            String supplied = null;
            if (verificationKey != null) {
                supplied = verificationKey.getClass().getName();
            }
            String needed = PublicKey.class.getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this.signatureAlgorithm.initVerify((PublicKey)verificationKey);
        }
        catch (InvalidKeyException e) {
            try {
                this.signatureAlgorithm = Signature.getInstance(this.signatureAlgorithm.getAlgorithm());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new XMLSignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws XMLSignatureException {
        try {
            return this.signatureAlgorithm.verify(signature);
        }
        catch (SignatureException e) {
            throw new XMLSignatureException(e.toString());
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.setParameter(params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new XMLSignatureException(e.toString());
        }
    }

    @Override
    protected void engineSetHMACOutputLength(int hmacOutputLength) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    public static class Gost3410_2012_512_Urn
    extends SignatureGost {
        @Override
        protected String engineGetURI() {
            return "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102012-gostr34112012-512";
        }
    }

    public static class Gost3410_2012_512_Uri
    extends SignatureGost {
        @Override
        protected String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#gostr34102012-gostr34112012-512";
        }
    }

    public static class Gost3410_2012_256_Urn
    extends SignatureGost {
        @Override
        protected String engineGetURI() {
            return "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102012-gostr34112012-256";
        }
    }

    public static class Gost3410_2012_256_Uri
    extends SignatureGost {
        @Override
        protected String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#gostr34102012-gostr34112012-256";
        }
    }

    public static class Gost3410_2001_Urn
    extends SignatureGost {
        @Override
        protected String engineGetURI() {
            return "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102001-gostr3411";
        }
    }

    public static class Gost3410_2001_Uri
    extends SignatureGost {
        @Override
        protected String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#gostr34102001-gostr3411";
        }
    }
}

