/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Verifier {
    private static final Logger logger = LoggerFactory.getLogger(Verifier.class);

    private Verifier() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static Verifier getInstance() {
        return new Verifier();
    }

    public boolean verifyCmsSignature(Path data, Path cmsSignature) throws CMSException, CertificateException, FileNotFoundException {
        CMSSignedData signedData;
        if (data != null) {
            CMSProcessableFile signedContent = new CMSProcessableFile(data.toFile());
            signedData = new CMSSignedData((CMSProcessable)signedContent, (InputStream)new FileInputStream(cmsSignature.toFile()));
        } else {
            signedData = new CMSSignedData((InputStream)new FileInputStream(cmsSignature.toFile()));
        }
        return this.verifyCmsSignature(signedData);
    }

    public boolean verifyCmsSignature(byte[] content, byte[] cmsSignature) throws CMSException, CertificateException {
        CMSSignedData signedData;
        if (content != null) {
            CMSProcessableByteArray signedContent = new CMSProcessableByteArray(content);
            ByteArrayInputStream is = new ByteArrayInputStream(cmsSignature);
            signedData = new CMSSignedData((CMSProcessable)signedContent, (InputStream)is);
        } else {
            signedData = new CMSSignedData(cmsSignature);
        }
        return this.verifyCmsSignature(signedData);
    }

    public boolean verifyCmsSignature(CMSSignedData signedData) throws CertificateException {
        Store store = signedData.getCertificates();
        SignerInformationStore signers = signedData.getSignerInfos();
        Collection signerInformation = signers.getSigners();
        boolean valid = true;
        for (SignerInformation signer : signerInformation) {
            Collection certCollection = store.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
            try {
                valid &= signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert));
            }
            catch (CMSException | OperatorCreationException e) {
                logger.warn("Certificate of '{}', SN='{}' is not valid", new Object[]{cert.getIssuerDN(), cert.getSerialNumber(), cert});
            }
        }
        return valid;
    }
}

