/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign.app;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import ru.i_novus.common.sign.api.SignAlgorithmType;
import ru.i_novus.common.sign.util.CryptoIO;

public class PemToP12Converter {
    public static void main(String ... args) throws ParseException, IOException {
        PemToP12Converter pemToP12Converter = new PemToP12Converter();
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(pemToP12Converter.getOptions(), args);
        String certificateFileName = cmd.getOptionValue("certPemFile");
        String pkFileName = cmd.getOptionValue("privateKeyPemFile");
        String p12FileName = cmd.getOptionValue("p12File");
        String p12Password = cmd.getOptionValue("p12Password");
        Path certificateFile = Paths.get(certificateFileName, new String[0]);
        pemToP12Converter.checkFile(certificateFile);
        Path pkFile = Paths.get(pkFileName, new String[0]);
        pemToP12Converter.checkFile(pkFile);
        Path p12Path = Paths.get(p12FileName, new String[0]);
        if (p12Path.toFile().exists()) {
            Files.delete(p12Path);
        }
        CryptoIO cryptoIO = CryptoIO.getInstance();
        X509Certificate certificate = cryptoIO.readCertFromPEM(certificateFile);
        PrivateKey privateKey = cryptoIO.readPkFromPEM(pkFile, SignAlgorithmType.findByCertificate((X509Certificate)certificate));
        cryptoIO.createPkcs12File(p12Path, p12Password, privateKey, new X509Certificate[]{certificate});
    }

    private void checkFile(Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("\u0424\u0430\u0439\u043b '" + path + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("'" + path + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0444\u0430\u0439\u043b\u043e\u043c");
        }
        if (!Files.isReadable(path)) {
            throw new IllegalArgumentException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0444\u0430\u0439\u043b\u0430 '" + path + "'. \u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430");
        }
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("certPemFile", true, "\u041f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 PEM");
        options.addOption("privateKeyPemFile", true, "\u041f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 PEM");
        options.addOption("p12File", true, "\u041f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0430");
        options.addOption("p12Password", true, "\u041f\u0430\u0440\u043e\u043b\u044c \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0430");
        return options;
    }
}

