/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.i_novus.common.sign.Init;
import ru.i_novus.common.sign.api.SignAlgorithmType;
import ru.i_novus.common.sign.util.Base64Util;
import ru.i_novus.common.sign.util.CryptoIO;

public class CryptoFormatConverter {
    private static final Logger logger = LoggerFactory.getLogger(CryptoFormatConverter.class);

    private CryptoFormatConverter() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Init.init();
    }

    public static CryptoFormatConverter getInstance() {
        return new CryptoFormatConverter();
    }

    public String getPEMEncodedCertificate(X509Certificate certificate) {
        try {
            return Base64Util.getBase64EncodedString(CryptoIO.getInstance().writeCertToByteArray((X509CertificateHolder)new JcaX509CertificateHolder(certificate)));
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("Cannot convert certificate to PEM", e);
        }
    }

    public X509Certificate getCertificateFromPEMEncoded(String pemEncodedCertificate) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(CryptoFormatConverter.decodePem(pemEncodedCertificate)));
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Cannot convert certificate from PEM", e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Provider is unknown", e);
        }
    }

    public X509Certificate getCertificateFromHolder(X509CertificateHolder certificateHolder) {
        JcaX509CertificateConverter jcaConverter = new JcaX509CertificateConverter();
        jcaConverter.setProvider("BC");
        try {
            return jcaConverter.getCertificate(certificateHolder);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Cannot receive certificate from Holder", e);
        }
    }

    public PrivateKey getPKFromPEMEncoded(SignAlgorithmType signAlgorithmType, String pemEncodedKey) {
        try {
            return KeyFactory.getInstance(signAlgorithmType.getBouncyKeyAlgorithmName(), "BC").generatePrivate(new PKCS8EncodedKeySpec(CryptoFormatConverter.decodePem(pemEncodedKey)));
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException("Provider is not initialized", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm " + signAlgorithmType + " is not supported", e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Wrong private key", e);
        }
    }

    public String getPEMEncodedCertificateFromPKCS12(String pfxFileEncoded, String keystorePass) {
        String string;
        byte[] decoded = Base64Util.getBase64Decoded(pfxFileEncoded);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(decoded);
        try {
            X509Certificate x509Certificate = CryptoIO.getInstance().readCertificateFromPKCS12(inputStream, keystorePass);
            string = this.getPEMEncodedCertificate(x509Certificate);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return string;
    }

    public static byte[] decodePem(String pemEncoded) {
        String pem = pemEncoded;
        try {
            pem = pem.replace(pem.substring(pem.indexOf("-----END"), pem.lastIndexOf("-----") + 5), "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            pem = pem.replace(pem.substring(pem.indexOf("-----BEGIN"), pem.lastIndexOf("-----") + 5), "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Base64Util.getBase64Decoded(pem.replaceAll("\\r\\n|\\n", ""));
    }
}

