/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12PfxPduBuilder;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.bc.BcPKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.bc.BcPKCS12PBEOutputEncryptorBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS12SafeBagBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.i_novus.common.sign.api.SignAlgorithmType;
import ru.i_novus.common.sign.util.Base64Util;
import ru.i_novus.common.sign.util.CryptoFormatConverter;

public class CryptoIO {
    private static final Logger logger = LoggerFactory.getLogger(CryptoIO.class);
    private static final int BUFFER_SIZE = 1024;

    private CryptoIO() {
    }

    public static CryptoIO getInstance() {
        return new CryptoIO();
    }

    public PKCS8EncodedKeySpec readPkFromPKCS8(String keyPath) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(keyPath, new String[0]));
            return new PKCS8EncodedKeySpec(data);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read PK from PKCS8", e);
        }
    }

    public PrivateKey readPrivateKey(InputStream input) throws IOException, GeneralSecurityException {
        PEMParser pemReader = new PEMParser((Reader)new InputStreamReader(input));
        PrivateKeyInfo pki = (PrivateKeyInfo)pemReader.readObject();
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(pki.getEncoded());
        String algOid = pki.getPrivateKeyAlgorithm().getAlgorithm().getId();
        return KeyFactory.getInstance(algOid).generatePrivate(spec);
    }

    public PrivateKey readPkFromPEM(Path keyPath, SignAlgorithmType algorithmType) {
        try {
            byte[] data = Files.readAllBytes(keyPath);
            return CryptoFormatConverter.getInstance().getPKFromPEMEncoded(algorithmType, new String(data));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read key from path '" + keyPath + "'", e);
        }
    }

    public X509CertificateHolder readCertFromDER(String crtPath) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(crtPath, new String[0]));
            return new X509CertificateHolder(data);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read certificate from path '" + crtPath + "'", e);
        }
    }

    public X509Certificate readCertFromPEM(Path crtPath) {
        try {
            byte[] data = Files.readAllBytes(crtPath);
            return CryptoFormatConverter.getInstance().getCertificateFromPEMEncoded(new String(data));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read certificate from path '" + crtPath + "'", e);
        }
    }

    public String writeCertToDERFile(X509CertificateHolder certificateHolder, Path path) {
        try {
            if (path.toFile().exists()) {
                Files.delete(path);
            }
            try (OutputStream fos = Files.newOutputStream(path, StandardOpenOption.CREATE);){
                fos.write(certificateHolder.getEncoded());
            }
            return path.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot write certificate to path '" + path + "' in DER", e);
        }
    }

    public byte[] writeCertToByteArray(X509CertificateHolder certificateHolder) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(certificateHolder.getEncoded());
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot convert certificate to byte array", e);
        }
    }

    public String writePKToPKCS8File(KeyPair keyPair, Path path) {
        try (OutputStream fos = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyPair.getPrivate().getEncoded());
            fos.write(pkcs8EncodedKeySpec.getEncoded());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot write PK to file '" + path + "'", e);
        }
        return path.toString();
    }

    public byte[] writePKToByteArray(PrivateKey privateKey) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        try {
            stream.write(pkcs8EncodedKeySpec.getEncoded());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot write PKCS8 encoded key to byte array", e);
        }
        return stream.toByteArray();
    }

    public PrivateKey readPrivateKeyFromPKCS12(Path filePath, String keystorePass) {
        try {
            return this.readPrivateKeyFromPKCS12(Files.newInputStream(filePath, new OpenOption[0]), keystorePass);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read file '" + filePath + "'", e);
        }
    }

    public KeyStore getPkcs12KeyStore(InputStream inputStream, String keystorePass) {
        try {
            KeyStore keyStore = KeyStore.getInstance("pkcs12", "BC");
            keyStore.load(inputStream, keystorePass == null ? null : keystorePass.toCharArray());
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new IllegalArgumentException("Cannot read private key from keystore", e);
        }
    }

    public PrivateKey readPrivateKeyFromPKCS12(KeyStore keyStore, String keystorePass) {
        String alias;
        try {
            alias = keyStore.aliases().nextElement();
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Keystore is invalid. Cannot read certificate chain", e);
        }
        try {
            return (PrivateKey)keyStore.getKey(alias, keystorePass == null ? null : keystorePass.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Cannot read private key from keystore", e);
        }
    }

    public X509Certificate readCertificateFromPKCS12(InputStream inputStream, String keystorePass) {
        KeyStore keyStore = this.getPkcs12KeyStore(inputStream, keystorePass);
        return this.readCertificateFromPKCS12(keyStore);
    }

    public X509Certificate readCertificateFromPKCS12(KeyStore keyStore) {
        try {
            String alias = keyStore.aliases().nextElement();
            Certificate[] chain = keyStore.getCertificateChain(alias);
            return (X509Certificate)chain[chain.length - 1];
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Keystore is invalid. Cannot read certificate chain", e);
        }
    }

    public PrivateKey readPrivateKeyFromPKCS12(InputStream inputStream, String keystorePass) {
        KeyStore keyStore = this.getPkcs12KeyStore(inputStream, keystorePass);
        return this.readPrivateKeyFromPKCS12(keyStore, keystorePass);
    }

    public X509Certificate readCertificateFromPKCS12(Path filePath, String keystorePass) {
        try {
            return this.readCertificateFromPKCS12(Files.newInputStream(filePath, new OpenOption[0]), keystorePass);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read file '" + filePath + "'", e);
        }
    }

    public void createPkcs12File(Path filePath, String password, PrivateKey privateKey, X509Certificate[] chain) {
        PKCS12PfxPdu pfx = this.createPkcs12PfxPdu(password, privateKey, chain);
        try (OutputStream stream = Files.newOutputStream(filePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            stream.write(pfx.getEncoded());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String createPkcs12FileEncoded(String password, PrivateKey privateKey, X509Certificate[] chain) {
        try {
            PKCS12PfxPdu pfx = this.createPkcs12PfxPdu(password, privateKey, chain);
            return Base64Util.getBase64EncodedString(pfx.getEncoded());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot create Pkcs12File", e);
        }
    }

    public PKCS12PfxPdu createPkcs12PfxPdu(String password, PrivateKey privateKey, X509Certificate[] chain) {
        if (chain.length == 0) {
            throw new IllegalArgumentException("Cannot build PKCS12 without certificates");
        }
        PublicKey publicKey = chain[0].getPublicKey();
        JcaX509ExtensionUtils extUtils = null;
        try {
            extUtils = new JcaX509ExtensionUtils();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot find algorithm 'SHA1'", e);
        }
        PKCS12SafeBag[] safeBags = new PKCS12SafeBag[chain.length];
        for (int i = chain.length - 1; i >= 0; --i) {
            JcaPKCS12SafeBagBuilder certBagBuilder = null;
            try {
                certBagBuilder = new JcaPKCS12SafeBagBuilder(chain[i]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot init certificate chain entry", e);
            }
            if (i == 0) {
                certBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(publicKey));
            }
            safeBags[i] = certBagBuilder.build();
        }
        JcaPKCS12SafeBagBuilder keyBagBuilder = new JcaPKCS12SafeBagBuilder(privateKey, new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine())).build(password.toCharArray()));
        keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(publicKey));
        PKCS12PfxPduBuilder pfxPduBuilder = new PKCS12PfxPduBuilder();
        try {
            pfxPduBuilder.addEncryptedData(new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new RC2Engine())).build(password.toCharArray()), safeBags);
            pfxPduBuilder.addData(keyBagBuilder.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot build PFX", e);
        }
        try {
            return pfxPduBuilder.build((PKCS12MacCalculatorBuilder)new BcPKCS12MacCalculatorBuilder(), password.toCharArray());
        }
        catch (PKCSException e) {
            throw new RuntimeException("Cannot build PFX container", e);
        }
    }

    public byte[] inputStreamToByteArray(InputStream inputStream) {
        try {
            return this.inputStreamToByteArray(inputStream, 1024);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read input stream", e);
        }
    }

    public byte[] inputStreamToByteArray(InputStream inputStream, int bufferSize) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[bufferSize];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

