/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.feign.jaxrs;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.qualys.feign.jaxrs.BeanParamTransformer;
import com.qualys.feign.jaxrs.ReflectionUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

class BeanParamTransformerFactory {
    BeanParamTransformerFactory() {
    }

    Multimap<String, Annotation> getNames(Annotation[] annotations) {
        ImmutableMultimap.Builder names = ImmutableMultimap.builder();
        for (Annotation annotation : annotations) {
            Class<?> cls = annotation.getClass();
            if (QueryParam.class.isAssignableFrom(cls)) {
                names.put((Object)((QueryParam)annotation).value(), (Object)annotation);
            }
            if (FormParam.class.isAssignableFrom(cls)) {
                names.put((Object)((FormParam)annotation).value(), (Object)annotation);
            }
            if (HeaderParam.class.isAssignableFrom(cls)) {
                names.put((Object)((HeaderParam)annotation).value(), (Object)annotation);
            }
            if (!PathParam.class.isAssignableFrom(cls)) continue;
            names.put((Object)((PathParam)annotation).value(), (Object)annotation);
        }
        return names.build();
    }

    protected BeanParamTransformer createTransformer(Type beanClass, int paramIndex) {
        try {
            ArrayList<BeanParamPropertyMetadata> propertyMetas = new ArrayList<BeanParamPropertyMetadata>();
            HashMap<String, PropertyDescriptor> descriptorsByName = new HashMap<String, PropertyDescriptor>();
            BeanInfo info = Introspector.getBeanInfo((Class)beanClass);
            for (PropertyDescriptor prop : info.getPropertyDescriptors()) {
                Multimap<String, Annotation> names;
                if (prop.getReadMethod() != null && prop.getWriteMethod() != null && !(names = this.getNames(prop.getWriteMethod().getAnnotations())).isEmpty()) {
                    propertyMetas.add(new BeanParamPropertyMetadata(names, null, prop.getReadMethod()));
                }
                descriptorsByName.put(prop.getName(), prop);
            }
            for (Field field : ReflectionUtil.getAllDeclaredFields((Class)beanClass, true)) {
                Multimap<String, Annotation> names;
                String fieldName = field.getName();
                if (descriptorsByName.containsKey(fieldName)) {
                    PropertyDescriptor descriptor = (PropertyDescriptor)descriptorsByName.get(fieldName);
                    Multimap<String, Annotation> names2 = this.getNames(field.getAnnotations());
                    if (descriptor.getReadMethod() != null && !names2.isEmpty()) {
                        propertyMetas.add(new BeanParamPropertyMetadata(names2, null, descriptor.getReadMethod()));
                        continue;
                    }
                }
                if ((names = this.getNames(field.getAnnotations())).isEmpty()) continue;
                propertyMetas.add(new BeanParamPropertyMetadata(names, field, null));
            }
            String[][] names = new String[propertyMetas.size()][];
            Method[] getters = new Method[propertyMetas.size()];
            Field[] fields = new Field[propertyMetas.size()];
            ArrayListMultimap params = ArrayListMultimap.create();
            for (int i = 0; i < propertyMetas.size(); ++i) {
                BeanParamPropertyMetadata propertyMetadata = (BeanParamPropertyMetadata)propertyMetas.get(i);
                fields[i] = propertyMetadata.property;
                getters[i] = propertyMetadata.getter;
                names[i] = propertyMetadata.names.keySet().toArray(new String[0]);
                Multimaps.invertFrom((Multimap)Multimaps.transformValues(propertyMetadata.names, v -> v.getClass().getInterfaces()[0]), (Multimap)params);
            }
            return new BeanParamTransformer(names, (Multimap<Class<?>, String>)ImmutableMultimap.copyOf((Multimap)params), fields, getters, paramIndex);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(String.format("Unable to build bean info for %s", beanClass), e);
        }
    }

    static class BeanParamPropertyMetadata {
        final Multimap<String, Annotation> names;
        final Field property;
        final Method getter;

        public BeanParamPropertyMetadata(Multimap<String, Annotation> names, Field property, Method getter) {
            this.names = names;
            this.property = property;
            this.getter = getter;
        }
    }
}

