/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.datastorage.temporal.model.value;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.i_novus.platform.datastorage.temporal.CollectionUtils;
import ru.i_novus.platform.datastorage.temporal.model.FieldValue;

public abstract class RowValue<T> {
    private T systemId;
    private List<FieldValue> fieldValues = new ArrayList<FieldValue>();
    private String hash;

    public RowValue() {
    }

    public RowValue(T systemId, List<FieldValue> fieldValues) {
        this.systemId = systemId;
        this.fieldValues = fieldValues;
    }

    public RowValue(T systemId, List<FieldValue> fieldValues, String hash) {
        this.systemId = systemId;
        this.fieldValues = fieldValues;
        this.hash = hash;
    }

    public T getSystemId() {
        return this.systemId;
    }

    public void setSystemId(T systemId) {
        this.systemId = systemId;
    }

    public List<FieldValue> getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(List<FieldValue> fieldValues) {
        this.fieldValues = fieldValues;
    }

    public FieldValue getFieldValue(String fieldName) {
        return !CollectionUtils.isNullOrEmpty(this.fieldValues) ? (FieldValue)this.fieldValues.stream().filter(fieldValue -> fieldName.equals(fieldValue.getField())).findFirst().orElse(null) : null;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowValue rowValue = (RowValue)o;
        return Objects.equals(this.systemId, rowValue.systemId) && Objects.equals(this.fieldValues, rowValue.fieldValues) && Objects.equals(this.hash, rowValue.hash);
    }

    public int hashCode() {
        return Objects.hash(this.systemId, this.fieldValues, this.hash);
    }

    public String toString() {
        return "RowValue{systemId=" + this.systemId + ", fieldValues=" + this.fieldValues + ", hash='" + this.hash + '\'' + '}';
    }
}

